/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.SecurityEventSubject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="The subject's identifier has changed, which is either an email address or a phone number change")
@JsonPropertyOrder(value={"event_timestamp", "new-value", "subjects"})
public class RiscIdentifierChangedEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_EVENT_TIMESTAMP = "event_timestamp";
    private Long eventTimestamp;
    public static final String JSON_PROPERTY_NEW_VALUE = "new-value";
    private String newValue;
    public static final String JSON_PROPERTY_SUBJECTS = "subjects";
    private SecurityEventSubject subjects;

    public RiscIdentifierChangedEvent eventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1702448550", required=true, value="The time of the event (UNIX timestamp)")
    @JsonProperty(value="event_timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getEventTimestamp() {
        return this.eventTimestamp;
    }

    @JsonProperty(value="event_timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public RiscIdentifierChangedEvent newValue(String newValue) {
        this.newValue = newValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="new.email@okta.example.com", value="The new identifier value")
    @JsonProperty(value="new-value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNewValue() {
        return this.newValue;
    }

    @JsonProperty(value="new-value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public RiscIdentifierChangedEvent subjects(SecurityEventSubject subjects) {
        this.subjects = subjects;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="subjects")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityEventSubject getSubjects() {
        return this.subjects;
    }

    @JsonProperty(value="subjects")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubjects(SecurityEventSubject subjects) {
        this.subjects = subjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RiscIdentifierChangedEvent riscIdentifierChangedEvent = (RiscIdentifierChangedEvent)o;
        return Objects.equals(this.eventTimestamp, riscIdentifierChangedEvent.eventTimestamp) && Objects.equals(this.newValue, riscIdentifierChangedEvent.newValue) && Objects.equals(this.subjects, riscIdentifierChangedEvent.subjects);
    }

    public int hashCode() {
        return Objects.hash(this.eventTimestamp, this.newValue, this.subjects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RiscIdentifierChangedEvent {\n");
        sb.append("    eventTimestamp: ").append(this.toIndentedString(this.eventTimestamp)).append("\n");
        sb.append("    newValue: ").append(this.toIndentedString(this.newValue)).append("\n");
        sb.append("    subjects: ").append(this.toIndentedString(this.subjects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

