/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Slack app instance properties")
@JsonPropertyOrder(value={"domain", "userEmailValue"})
public class SlackApplicationSettingsApplication
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;
    public static final String JSON_PROPERTY_USER_EMAIL_VALUE = "userEmailValue";
    private String userEmailValue;

    public SlackApplicationSettingsApplication domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The Slack app domain name")
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public SlackApplicationSettingsApplication userEmailValue(String userEmailValue) {
        this.userEmailValue = userEmailValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `User.Email` attribute value")
    @JsonProperty(value="userEmailValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserEmailValue() {
        return this.userEmailValue;
    }

    @JsonProperty(value="userEmailValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserEmailValue(String userEmailValue) {
        this.userEmailValue = userEmailValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlackApplicationSettingsApplication slackApplicationSettingsApplication = (SlackApplicationSettingsApplication)o;
        return Objects.equals(this.domain, slackApplicationSettingsApplication.domain) && Objects.equals(this.userEmailValue, slackApplicationSettingsApplication.userEmailValue);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.userEmailValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SlackApplicationSettingsApplication {\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    userEmailValue: ").append(this.toIndentedString(this.userEmailValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

