/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.StreamConfigurationDelivery;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"delivery", "events_requested", "format"})
public class StreamConfigurationCreateRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DELIVERY = "delivery";
    private StreamConfigurationDelivery delivery;
    public static final String JSON_PROPERTY_EVENTS_REQUESTED = "events_requested";
    private List<URI> eventsRequested = new ArrayList<URI>();
    public static final String JSON_PROPERTY_FORMAT = "format";
    private FormatEnum format;

    public StreamConfigurationCreateRequest delivery(StreamConfigurationDelivery delivery) {
        this.delivery = delivery;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="delivery")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StreamConfigurationDelivery getDelivery() {
        return this.delivery;
    }

    @JsonProperty(value="delivery")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDelivery(StreamConfigurationDelivery delivery) {
        this.delivery = delivery;
    }

    public StreamConfigurationCreateRequest eventsRequested(List<URI> eventsRequested) {
        this.eventsRequested = eventsRequested;
        return this;
    }

    public StreamConfigurationCreateRequest addeventsRequestedItem(URI eventsRequestedItem) {
        if (this.eventsRequested == null) {
            this.eventsRequested = new ArrayList<URI>();
        }
        this.eventsRequested.add(eventsRequestedItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[\"https://schemas.openid.net/secevent/caep/event-type/session-revoked\",\"https://schemas.openid.net/secevent/caep/event-type/credential-change\"]", required=true, value="The events (mapped by the array of event type URIs) that the receiver wants to receive")
    @JsonProperty(value="events_requested")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<URI> getEventsRequested() {
        return this.eventsRequested;
    }

    @JsonProperty(value="events_requested")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventsRequested(List<URI> eventsRequested) {
        this.eventsRequested = eventsRequested;
    }

    public StreamConfigurationCreateRequest format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Subject Identifier format expected for any SET transmitted.")
    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormatEnum getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamConfigurationCreateRequest streamConfigurationCreateRequest = (StreamConfigurationCreateRequest)o;
        return Objects.equals(this.delivery, streamConfigurationCreateRequest.delivery) && Objects.equals(this.eventsRequested, streamConfigurationCreateRequest.eventsRequested) && Objects.equals((Object)this.format, (Object)streamConfigurationCreateRequest.format);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.delivery, this.eventsRequested, this.format});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StreamConfigurationCreateRequest {\n");
        sb.append("    delivery: ").append(this.toIndentedString(this.delivery)).append("\n");
        sb.append("    eventsRequested: ").append(this.toIndentedString(this.eventsRequested)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FormatEnum {
        ISS_SUB("iss_sub"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

