/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Specifies the default and custom profile properties for a user.  The default user profile is based on the [System for Cross-domain Identity Management: Core Schema](https://datatracker.ietf.org/doc/html/rfc7643). The only permitted customizations of the default profile are to update permissions, change whether the `firstName` and `lastName` properties are nullable, and  specify a [pattern](https://developer.okta.com/docs/reference/api/schemas/#login-pattern-validation) for `login`. You can use the Profile Editor in the administrator UI or the [Schemas API](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UISchema/#tag/UISchema) to make schema modifications.  You can extend user profiles with custom properties. You must first add the custom property to the user profile schema before you reference it. You can use the Profile Editor in the Admin console or the [Schemas API](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UISchema/#tag/UISchema) to manage schema extensions.  Custom attributes may contain HTML tags. It's the client's responsibility to escape or encode this data before displaying it. Use [best-practices](https://cheatsheetseries.owasp.org/cheatsheets/Cross_Site_Scripting_Prevention_Cheat_Sheet.html) to prevent cross-site scripting.")
@JsonPropertyOrder(value={"city", "costCenter", "countryCode", "department", "displayName", "division", "email", "employeeNumber", "firstName", "honorificPrefix", "honorificSuffix", "lastName", "locale", "login", "manager", "managerId", "middleName", "mobilePhone", "nickName", "organization", "postalAddress", "preferredLanguage", "primaryPhone", "profileUrl", "secondEmail", "state", "streetAddress", "timezone", "title", "userType", "zipCode"})
public class UserProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    public static final String JSON_PROPERTY_CITY = "city";
    private JsonNullable<String> city = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COST_CENTER = "costCenter";
    private JsonNullable<String> costCenter = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private JsonNullable<String> countryCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEPARTMENT = "department";
    private String department;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private JsonNullable<String> displayName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DIVISION = "division";
    private JsonNullable<String> division = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_EMPLOYEE_NUMBER = "employeeNumber";
    private String employeeNumber;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private JsonNullable<String> firstName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_HONORIFIC_PREFIX = "honorificPrefix";
    private JsonNullable<String> honorificPrefix = JsonNullable.undefined();
    public static final String JSON_PROPERTY_HONORIFIC_SUFFIX = "honorificSuffix";
    private JsonNullable<String> honorificSuffix = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private JsonNullable<String> lastName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LOCALE = "locale";
    private String locale;
    public static final String JSON_PROPERTY_LOGIN = "login";
    private String login;
    public static final String JSON_PROPERTY_MANAGER = "manager";
    private JsonNullable<String> manager = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MANAGER_ID = "managerId";
    private JsonNullable<String> managerId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MIDDLE_NAME = "middleName";
    private JsonNullable<String> middleName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MOBILE_PHONE = "mobilePhone";
    private JsonNullable<String> mobilePhone = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NICK_NAME = "nickName";
    private JsonNullable<String> nickName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ORGANIZATION = "organization";
    private JsonNullable<String> organization = JsonNullable.undefined();
    public static final String JSON_PROPERTY_POSTAL_ADDRESS = "postalAddress";
    private JsonNullable<String> postalAddress = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PREFERRED_LANGUAGE = "preferredLanguage";
    private JsonNullable<String> preferredLanguage = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PRIMARY_PHONE = "primaryPhone";
    private JsonNullable<String> primaryPhone = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PROFILE_URL = "profileUrl";
    private JsonNullable<String> profileUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SECOND_EMAIL = "secondEmail";
    private JsonNullable<String> secondEmail = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATE = "state";
    private JsonNullable<String> state = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STREET_ADDRESS = "streetAddress";
    private JsonNullable<String> streetAddress = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private JsonNullable<String> timezone = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TITLE = "title";
    private JsonNullable<String> title = JsonNullable.undefined();
    public static final String JSON_PROPERTY_USER_TYPE = "userType";
    private JsonNullable<String> userType = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ZIP_CODE = "zipCode";
    private JsonNullable<String> zipCode = JsonNullable.undefined();

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public UserProfile city(String city) {
        this.city = JsonNullable.of((Object)city);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The city or locality of the user's address (`locality`)")
    @JsonIgnore
    public String getCity() {
        return (String)this.city.orElse(null);
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCity_JsonNullable() {
        return this.city;
    }

    @JsonProperty(value="city")
    public void setCity_JsonNullable(JsonNullable<String> city) {
        this.city = city;
    }

    public void setCity(String city) {
        this.city = JsonNullable.of((Object)city);
    }

    public UserProfile costCenter(String costCenter) {
        this.costCenter = JsonNullable.of((Object)costCenter);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the cost center assigned to a user")
    @JsonIgnore
    public String getCostCenter() {
        return (String)this.costCenter.orElse(null);
    }

    @JsonProperty(value="costCenter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCostCenter_JsonNullable() {
        return this.costCenter;
    }

    @JsonProperty(value="costCenter")
    public void setCostCenter_JsonNullable(JsonNullable<String> costCenter) {
        this.costCenter = costCenter;
    }

    public void setCostCenter(String costCenter) {
        this.costCenter = JsonNullable.of((Object)costCenter);
    }

    public UserProfile countryCode(String countryCode) {
        this.countryCode = JsonNullable.of((Object)countryCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The country name component of the user's address (`country`)")
    @JsonIgnore
    public String getCountryCode() {
        return (String)this.countryCode.orElse(null);
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCountryCode_JsonNullable() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    public void setCountryCode_JsonNullable(JsonNullable<String> countryCode) {
        this.countryCode = countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = JsonNullable.of((Object)countryCode);
    }

    public UserProfile department(String department) {
        this.department = department;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the user's department")
    @JsonProperty(value="department")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDepartment() {
        return this.department;
    }

    @JsonProperty(value="department")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDepartment(String department) {
        this.department = department;
    }

    public UserProfile displayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the user suitable for display to end users")
    @JsonIgnore
    public String getDisplayName() {
        return (String)this.displayName.orElse(null);
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDisplayName_JsonNullable() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName_JsonNullable(JsonNullable<String> displayName) {
        this.displayName = displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
    }

    public UserProfile division(String division) {
        this.division = JsonNullable.of((Object)division);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the user's division")
    @JsonIgnore
    public String getDivision() {
        return (String)this.division.orElse(null);
    }

    @JsonProperty(value="division")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDivision_JsonNullable() {
        return this.division;
    }

    @JsonProperty(value="division")
    public void setDivision_JsonNullable(JsonNullable<String> division) {
        this.division = division;
    }

    public void setDivision(String division) {
        this.division = JsonNullable.of((Object)division);
    }

    public UserProfile email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The primary email address of the user. For validation, see [RFC 5322 Section 3.2.3](https://datatracker.ietf.org/doc/html/rfc5322#section-3.2.3).")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public UserProfile employeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The organization or company assigned unique identifier for the user")
    @JsonProperty(value="employeeNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    @JsonProperty(value="employeeNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    public UserProfile firstName(String firstName) {
        this.firstName = JsonNullable.of((Object)firstName);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Given name of the user (`givenName`)")
    @JsonIgnore
    public String getFirstName() {
        return (String)this.firstName.orElse(null);
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFirstName_JsonNullable() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    public void setFirstName_JsonNullable(JsonNullable<String> firstName) {
        this.firstName = firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = JsonNullable.of((Object)firstName);
    }

    public UserProfile honorificPrefix(String honorificPrefix) {
        this.honorificPrefix = JsonNullable.of((Object)honorificPrefix);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Honorific prefix(es) of the user, or title in most Western languages")
    @JsonIgnore
    public String getHonorificPrefix() {
        return (String)this.honorificPrefix.orElse(null);
    }

    @JsonProperty(value="honorificPrefix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getHonorificPrefix_JsonNullable() {
        return this.honorificPrefix;
    }

    @JsonProperty(value="honorificPrefix")
    public void setHonorificPrefix_JsonNullable(JsonNullable<String> honorificPrefix) {
        this.honorificPrefix = honorificPrefix;
    }

    public void setHonorificPrefix(String honorificPrefix) {
        this.honorificPrefix = JsonNullable.of((Object)honorificPrefix);
    }

    public UserProfile honorificSuffix(String honorificSuffix) {
        this.honorificSuffix = JsonNullable.of((Object)honorificSuffix);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Honorific suffix(es) of the user")
    @JsonIgnore
    public String getHonorificSuffix() {
        return (String)this.honorificSuffix.orElse(null);
    }

    @JsonProperty(value="honorificSuffix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getHonorificSuffix_JsonNullable() {
        return this.honorificSuffix;
    }

    @JsonProperty(value="honorificSuffix")
    public void setHonorificSuffix_JsonNullable(JsonNullable<String> honorificSuffix) {
        this.honorificSuffix = honorificSuffix;
    }

    public void setHonorificSuffix(String honorificSuffix) {
        this.honorificSuffix = JsonNullable.of((Object)honorificSuffix);
    }

    public UserProfile lastName(String lastName) {
        this.lastName = JsonNullable.of((Object)lastName);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The family name of the user (`familyName`)")
    @JsonIgnore
    public String getLastName() {
        return (String)this.lastName.orElse(null);
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLastName_JsonNullable() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    public void setLastName_JsonNullable(JsonNullable<String> lastName) {
        this.lastName = lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = JsonNullable.of((Object)lastName);
    }

    public UserProfile locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's default location for purposes of localizing items such as currency, date time format, numerical representations, and so on. A locale value is a concatenation of the ISO 639-1 two-letter language code, an underscore, and the ISO 3166-1 two-letter country code. For example, en_US specifies the language English and country US. This value is `en_US` by default.")
    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocale() {
        return this.locale;
    }

    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocale(String locale) {
        this.locale = locale;
    }

    public UserProfile login(String login) {
        this.login = login;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the user (`username`). For validation, see [Login pattern validation](https://developer.okta.com/docs/reference/api/schemas/#login-pattern-validation). See also [Okta login](https://developer.okta.com/docs/reference/api/users/#okta-login).")
    @JsonProperty(value="login")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogin() {
        return this.login;
    }

    @JsonProperty(value="login")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogin(String login) {
        this.login = login;
    }

    public UserProfile manager(String manager) {
        this.manager = JsonNullable.of((Object)manager);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `displayName` of the user's manager")
    @JsonIgnore
    public String getManager() {
        return (String)this.manager.orElse(null);
    }

    @JsonProperty(value="manager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getManager_JsonNullable() {
        return this.manager;
    }

    @JsonProperty(value="manager")
    public void setManager_JsonNullable(JsonNullable<String> manager) {
        this.manager = manager;
    }

    public void setManager(String manager) {
        this.manager = JsonNullable.of((Object)manager);
    }

    public UserProfile managerId(String managerId) {
        this.managerId = JsonNullable.of((Object)managerId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `id` of the user's manager")
    @JsonIgnore
    public String getManagerId() {
        return (String)this.managerId.orElse(null);
    }

    @JsonProperty(value="managerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getManagerId_JsonNullable() {
        return this.managerId;
    }

    @JsonProperty(value="managerId")
    public void setManagerId_JsonNullable(JsonNullable<String> managerId) {
        this.managerId = managerId;
    }

    public void setManagerId(String managerId) {
        this.managerId = JsonNullable.of((Object)managerId);
    }

    public UserProfile middleName(String middleName) {
        this.middleName = JsonNullable.of((Object)middleName);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The middle name of the user")
    @JsonIgnore
    public String getMiddleName() {
        return (String)this.middleName.orElse(null);
    }

    @JsonProperty(value="middleName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getMiddleName_JsonNullable() {
        return this.middleName;
    }

    @JsonProperty(value="middleName")
    public void setMiddleName_JsonNullable(JsonNullable<String> middleName) {
        this.middleName = middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = JsonNullable.of((Object)middleName);
    }

    public UserProfile mobilePhone(String mobilePhone) {
        this.mobilePhone = JsonNullable.of((Object)mobilePhone);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The mobile phone number of the user")
    @JsonIgnore
    public String getMobilePhone() {
        return (String)this.mobilePhone.orElse(null);
    }

    @JsonProperty(value="mobilePhone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getMobilePhone_JsonNullable() {
        return this.mobilePhone;
    }

    @JsonProperty(value="mobilePhone")
    public void setMobilePhone_JsonNullable(JsonNullable<String> mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = JsonNullable.of((Object)mobilePhone);
    }

    public UserProfile nickName(String nickName) {
        this.nickName = JsonNullable.of((Object)nickName);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The casual way to address the user in real life")
    @JsonIgnore
    public String getNickName() {
        return (String)this.nickName.orElse(null);
    }

    @JsonProperty(value="nickName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getNickName_JsonNullable() {
        return this.nickName;
    }

    @JsonProperty(value="nickName")
    public void setNickName_JsonNullable(JsonNullable<String> nickName) {
        this.nickName = nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = JsonNullable.of((Object)nickName);
    }

    public UserProfile organization(String organization) {
        this.organization = JsonNullable.of((Object)organization);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the the user's organization")
    @JsonIgnore
    public String getOrganization() {
        return (String)this.organization.orElse(null);
    }

    @JsonProperty(value="organization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getOrganization_JsonNullable() {
        return this.organization;
    }

    @JsonProperty(value="organization")
    public void setOrganization_JsonNullable(JsonNullable<String> organization) {
        this.organization = organization;
    }

    public void setOrganization(String organization) {
        this.organization = JsonNullable.of((Object)organization);
    }

    public UserProfile postalAddress(String postalAddress) {
        this.postalAddress = JsonNullable.of((Object)postalAddress);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Mailing address component of the user's address")
    @JsonIgnore
    public String getPostalAddress() {
        return (String)this.postalAddress.orElse(null);
    }

    @JsonProperty(value="postalAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPostalAddress_JsonNullable() {
        return this.postalAddress;
    }

    @JsonProperty(value="postalAddress")
    public void setPostalAddress_JsonNullable(JsonNullable<String> postalAddress) {
        this.postalAddress = postalAddress;
    }

    public void setPostalAddress(String postalAddress) {
        this.postalAddress = JsonNullable.of((Object)postalAddress);
    }

    public UserProfile preferredLanguage(String preferredLanguage) {
        this.preferredLanguage = JsonNullable.of((Object)preferredLanguage);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's preferred written or spoken language")
    @JsonIgnore
    public String getPreferredLanguage() {
        return (String)this.preferredLanguage.orElse(null);
    }

    @JsonProperty(value="preferredLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPreferredLanguage_JsonNullable() {
        return this.preferredLanguage;
    }

    @JsonProperty(value="preferredLanguage")
    public void setPreferredLanguage_JsonNullable(JsonNullable<String> preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = JsonNullable.of((Object)preferredLanguage);
    }

    public UserProfile primaryPhone(String primaryPhone) {
        this.primaryPhone = JsonNullable.of((Object)primaryPhone);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The primary phone number of the user such as a home number")
    @JsonIgnore
    public String getPrimaryPhone() {
        return (String)this.primaryPhone.orElse(null);
    }

    @JsonProperty(value="primaryPhone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPrimaryPhone_JsonNullable() {
        return this.primaryPhone;
    }

    @JsonProperty(value="primaryPhone")
    public void setPrimaryPhone_JsonNullable(JsonNullable<String> primaryPhone) {
        this.primaryPhone = primaryPhone;
    }

    public void setPrimaryPhone(String primaryPhone) {
        this.primaryPhone = JsonNullable.of((Object)primaryPhone);
    }

    public UserProfile profileUrl(String profileUrl) {
        this.profileUrl = JsonNullable.of((Object)profileUrl);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL of the user's online profile. For example, a web page. See [URL](https://datatracker.ietf.org/doc/html/rfc1808).")
    @JsonIgnore
    public String getProfileUrl() {
        return (String)this.profileUrl.orElse(null);
    }

    @JsonProperty(value="profileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getProfileUrl_JsonNullable() {
        return this.profileUrl;
    }

    @JsonProperty(value="profileUrl")
    public void setProfileUrl_JsonNullable(JsonNullable<String> profileUrl) {
        this.profileUrl = profileUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = JsonNullable.of((Object)profileUrl);
    }

    public UserProfile secondEmail(String secondEmail) {
        this.secondEmail = JsonNullable.of((Object)secondEmail);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The secondary email address of the user typically used for account recovery")
    @JsonIgnore
    public String getSecondEmail() {
        return (String)this.secondEmail.orElse(null);
    }

    @JsonProperty(value="secondEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSecondEmail_JsonNullable() {
        return this.secondEmail;
    }

    @JsonProperty(value="secondEmail")
    public void setSecondEmail_JsonNullable(JsonNullable<String> secondEmail) {
        this.secondEmail = secondEmail;
    }

    public void setSecondEmail(String secondEmail) {
        this.secondEmail = JsonNullable.of((Object)secondEmail);
    }

    public UserProfile state(String state) {
        this.state = JsonNullable.of((Object)state);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state or region component of the user's address (`region`)")
    @JsonIgnore
    public String getState() {
        return (String)this.state.orElse(null);
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getState_JsonNullable() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState_JsonNullable(JsonNullable<String> state) {
        this.state = state;
    }

    public void setState(String state) {
        this.state = JsonNullable.of((Object)state);
    }

    public UserProfile streetAddress(String streetAddress) {
        this.streetAddress = JsonNullable.of((Object)streetAddress);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The full street address component of the user's address")
    @JsonIgnore
    public String getStreetAddress() {
        return (String)this.streetAddress.orElse(null);
    }

    @JsonProperty(value="streetAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getStreetAddress_JsonNullable() {
        return this.streetAddress;
    }

    @JsonProperty(value="streetAddress")
    public void setStreetAddress_JsonNullable(JsonNullable<String> streetAddress) {
        this.streetAddress = streetAddress;
    }

    public void setStreetAddress(String streetAddress) {
        this.streetAddress = JsonNullable.of((Object)streetAddress);
    }

    public UserProfile timezone(String timezone) {
        this.timezone = JsonNullable.of((Object)timezone);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's time zone")
    @JsonIgnore
    public String getTimezone() {
        return (String)this.timezone.orElse(null);
    }

    @JsonProperty(value="timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getTimezone_JsonNullable() {
        return this.timezone;
    }

    @JsonProperty(value="timezone")
    public void setTimezone_JsonNullable(JsonNullable<String> timezone) {
        this.timezone = timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = JsonNullable.of((Object)timezone);
    }

    public UserProfile title(String title) {
        this.title = JsonNullable.of((Object)title);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's title, such as Vice President")
    @JsonIgnore
    public String getTitle() {
        return (String)this.title.orElse(null);
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getTitle_JsonNullable() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle_JsonNullable(JsonNullable<String> title) {
        this.title = title;
    }

    public void setTitle(String title) {
        this.title = JsonNullable.of((Object)title);
    }

    public UserProfile userType(String userType) {
        this.userType = JsonNullable.of((Object)userType);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The property used to describe the organization-to-user relationship, such as employee or contractor")
    @JsonIgnore
    public String getUserType() {
        return (String)this.userType.orElse(null);
    }

    @JsonProperty(value="userType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getUserType_JsonNullable() {
        return this.userType;
    }

    @JsonProperty(value="userType")
    public void setUserType_JsonNullable(JsonNullable<String> userType) {
        this.userType = userType;
    }

    public void setUserType(String userType) {
        this.userType = JsonNullable.of((Object)userType);
    }

    public UserProfile zipCode(String zipCode) {
        this.zipCode = JsonNullable.of((Object)zipCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ZIP code or postal code component of the user's address (`postalCode`)")
    @JsonIgnore
    public String getZipCode() {
        return (String)this.zipCode.orElse(null);
    }

    @JsonProperty(value="zipCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getZipCode_JsonNullable() {
        return this.zipCode;
    }

    @JsonProperty(value="zipCode")
    public void setZipCode_JsonNullable(JsonNullable<String> zipCode) {
        this.zipCode = zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = JsonNullable.of((Object)zipCode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserProfile userProfile = (UserProfile)o;
        return UserProfile.equalsNullable(this.city, userProfile.city) && UserProfile.equalsNullable(this.costCenter, userProfile.costCenter) && UserProfile.equalsNullable(this.countryCode, userProfile.countryCode) && Objects.equals(this.department, userProfile.department) && UserProfile.equalsNullable(this.displayName, userProfile.displayName) && UserProfile.equalsNullable(this.division, userProfile.division) && Objects.equals(this.email, userProfile.email) && Objects.equals(this.employeeNumber, userProfile.employeeNumber) && UserProfile.equalsNullable(this.firstName, userProfile.firstName) && UserProfile.equalsNullable(this.honorificPrefix, userProfile.honorificPrefix) && UserProfile.equalsNullable(this.honorificSuffix, userProfile.honorificSuffix) && UserProfile.equalsNullable(this.lastName, userProfile.lastName) && Objects.equals(this.locale, userProfile.locale) && Objects.equals(this.login, userProfile.login) && UserProfile.equalsNullable(this.manager, userProfile.manager) && UserProfile.equalsNullable(this.managerId, userProfile.managerId) && UserProfile.equalsNullable(this.middleName, userProfile.middleName) && UserProfile.equalsNullable(this.mobilePhone, userProfile.mobilePhone) && UserProfile.equalsNullable(this.nickName, userProfile.nickName) && UserProfile.equalsNullable(this.organization, userProfile.organization) && UserProfile.equalsNullable(this.postalAddress, userProfile.postalAddress) && UserProfile.equalsNullable(this.preferredLanguage, userProfile.preferredLanguage) && UserProfile.equalsNullable(this.primaryPhone, userProfile.primaryPhone) && UserProfile.equalsNullable(this.profileUrl, userProfile.profileUrl) && UserProfile.equalsNullable(this.secondEmail, userProfile.secondEmail) && UserProfile.equalsNullable(this.state, userProfile.state) && UserProfile.equalsNullable(this.streetAddress, userProfile.streetAddress) && UserProfile.equalsNullable(this.timezone, userProfile.timezone) && UserProfile.equalsNullable(this.title, userProfile.title) && UserProfile.equalsNullable(this.userType, userProfile.userType) && UserProfile.equalsNullable(this.zipCode, userProfile.zipCode);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(UserProfile.hashCodeNullable(this.city), UserProfile.hashCodeNullable(this.costCenter), UserProfile.hashCodeNullable(this.countryCode), this.department, UserProfile.hashCodeNullable(this.displayName), UserProfile.hashCodeNullable(this.division), this.email, this.employeeNumber, UserProfile.hashCodeNullable(this.firstName), UserProfile.hashCodeNullable(this.honorificPrefix), UserProfile.hashCodeNullable(this.honorificSuffix), UserProfile.hashCodeNullable(this.lastName), this.locale, this.login, UserProfile.hashCodeNullable(this.manager), UserProfile.hashCodeNullable(this.managerId), UserProfile.hashCodeNullable(this.middleName), UserProfile.hashCodeNullable(this.mobilePhone), UserProfile.hashCodeNullable(this.nickName), UserProfile.hashCodeNullable(this.organization), UserProfile.hashCodeNullable(this.postalAddress), UserProfile.hashCodeNullable(this.preferredLanguage), UserProfile.hashCodeNullable(this.primaryPhone), UserProfile.hashCodeNullable(this.profileUrl), UserProfile.hashCodeNullable(this.secondEmail), UserProfile.hashCodeNullable(this.state), UserProfile.hashCodeNullable(this.streetAddress), UserProfile.hashCodeNullable(this.timezone), UserProfile.hashCodeNullable(this.title), UserProfile.hashCodeNullable(this.userType), UserProfile.hashCodeNullable(this.zipCode), super.hashCode());
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserProfile {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    costCenter: ").append(this.toIndentedString(this.costCenter)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    department: ").append(this.toIndentedString(this.department)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    employeeNumber: ").append(this.toIndentedString(this.employeeNumber)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    honorificPrefix: ").append(this.toIndentedString(this.honorificPrefix)).append("\n");
        sb.append("    honorificSuffix: ").append(this.toIndentedString(this.honorificSuffix)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    manager: ").append(this.toIndentedString(this.manager)).append("\n");
        sb.append("    managerId: ").append(this.toIndentedString(this.managerId)).append("\n");
        sb.append("    middleName: ").append(this.toIndentedString(this.middleName)).append("\n");
        sb.append("    mobilePhone: ").append(this.toIndentedString(this.mobilePhone)).append("\n");
        sb.append("    nickName: ").append(this.toIndentedString(this.nickName)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    postalAddress: ").append(this.toIndentedString(this.postalAddress)).append("\n");
        sb.append("    preferredLanguage: ").append(this.toIndentedString(this.preferredLanguage)).append("\n");
        sb.append("    primaryPhone: ").append(this.toIndentedString(this.primaryPhone)).append("\n");
        sb.append("    profileUrl: ").append(this.toIndentedString(this.profileUrl)).append("\n");
        sb.append("    secondEmail: ").append(this.toIndentedString(this.secondEmail)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    streetAddress: ").append(this.toIndentedString(this.streetAddress)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    userType: ").append(this.toIndentedString(this.userType)).append("\n");
        sb.append("    zipCode: ").append(this.toIndentedString(this.zipCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

