/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.UserFactorProvider;
import com.okta.sdk.resource.model.UserFactorStatus;
import com.okta.sdk.resource.model.UserFactorType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="User Factor variant used for WebAuthn Preregistration Factors")
@JsonPropertyOrder(value={"created", "factorType", "id", "lastUpdated", "profile", "provider", "status", "vendorName", "_links"})
public class WebAuthnPreregistrationFactor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_FACTOR_TYPE = "factorType";
    private UserFactorType factorType;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Object profile;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private UserFactorProvider provider;
    public static final String JSON_PROPERTY_STATUS = "status";
    private UserFactorStatus status;
    public static final String JSON_PROPERTY_VENDOR_NAME = "vendorName";
    private String vendorName;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    @Nullable
    @ApiModelProperty(value="Timestamp indicating when the Factor was enrolled")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public WebAuthnPreregistrationFactor factorType(UserFactorType factorType) {
        this.factorType = factorType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="factorType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorType getFactorType() {
        return this.factorType;
    }

    @JsonProperty(value="factorType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFactorType(UserFactorType factorType) {
        this.factorType = factorType;
    }

    @Nullable
    @ApiModelProperty(value="ID of the Factor")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp indicating when the Factor was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public WebAuthnPreregistrationFactor profile(Object profile) {
        this.profile = profile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specific attributes related to the Factor")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Object profile) {
        this.profile = profile;
    }

    public WebAuthnPreregistrationFactor provider(UserFactorProvider provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorProvider getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(UserFactorProvider provider) {
        this.provider = provider;
    }

    public WebAuthnPreregistrationFactor status(UserFactorStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(UserFactorStatus status) {
        this.status = status;
    }

    @Nullable
    @ApiModelProperty(example="OKTA", value="Name of the Factor vendor. This is usually the same as the provider.")
    @JsonProperty(value="vendorName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVendorName() {
        return this.vendorName;
    }

    public WebAuthnPreregistrationFactor links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebAuthnPreregistrationFactor webAuthnPreregistrationFactor = (WebAuthnPreregistrationFactor)o;
        return Objects.equals(this.created, webAuthnPreregistrationFactor.created) && Objects.equals((Object)this.factorType, (Object)webAuthnPreregistrationFactor.factorType) && Objects.equals(this.id, webAuthnPreregistrationFactor.id) && Objects.equals(this.lastUpdated, webAuthnPreregistrationFactor.lastUpdated) && Objects.equals(this.profile, webAuthnPreregistrationFactor.profile) && Objects.equals((Object)this.provider, (Object)webAuthnPreregistrationFactor.provider) && Objects.equals((Object)this.status, (Object)webAuthnPreregistrationFactor.status) && Objects.equals(this.vendorName, webAuthnPreregistrationFactor.vendorName) && Objects.equals(this.links, webAuthnPreregistrationFactor.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.factorType, this.id, this.lastUpdated, this.profile, this.provider, this.status, this.vendorName, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebAuthnPreregistrationFactor {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    factorType: ").append(this.toIndentedString((Object)this.factorType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    vendorName: ").append(this.toIndentedString(this.vendorName)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

