/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.APIServiceIntegrationInstance;
import com.okta.sdk.resource.model.APIServiceIntegrationInstanceSecret;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.PostAPIServiceIntegrationInstance;
import com.okta.sdk.resource.model.PostAPIServiceIntegrationInstanceRequest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ApiServiceIntegrationsApi {

    private ApiClient apiClient;

    public ApiServiceIntegrationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiServiceIntegrationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate an API Service Integration instance Secret Activates an API Service Integration instance Secret by
     * &#x60;secretId&#x60;
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     * @param secretId
     *            &#x60;id&#x60; of the API Service Integration instance Secret (required)
     *
     * @return APIServiceIntegrationInstanceSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public APIServiceIntegrationInstanceSecret activateApiServiceIntegrationInstanceSecret(String apiServiceId,
            String secretId) throws ApiException {
        return this.activateApiServiceIntegrationInstanceSecret(apiServiceId, secretId, Collections.emptyMap());
    }

    /**
     * Activate an API Service Integration instance Secret Activates an API Service Integration instance Secret by
     * &#x60;secretId&#x60;
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     * @param secretId
     *            &#x60;id&#x60; of the API Service Integration instance Secret (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return APIServiceIntegrationInstanceSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public APIServiceIntegrationInstanceSecret activateApiServiceIntegrationInstanceSecret(String apiServiceId,
            String secretId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'apiServiceId' is set
        if (apiServiceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'apiServiceId' when calling activateApiServiceIntegrationInstanceSecret");
        }

        // verify the required parameter 'secretId' is set
        if (secretId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'secretId' when calling activateApiServiceIntegrationInstanceSecret");
        }

        // create path and map variables
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}/credentials/secrets/{secretId}/lifecycle/activate"
                .replaceAll("\\{" + "apiServiceId" + "\\}", apiClient.escapeString(apiServiceId.toString()))
                .replaceAll("\\{" + "secretId" + "\\}", apiClient.escapeString(secretId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<APIServiceIntegrationInstanceSecret> localVarReturnType = new TypeReference<APIServiceIntegrationInstanceSecret>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create an API Service Integration instance Creates and authorizes an API Service Integration instance
     *
     * @param postAPIServiceIntegrationInstanceRequest
     *            (required)
     *
     * @return PostAPIServiceIntegrationInstance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PostAPIServiceIntegrationInstance createApiServiceIntegrationInstance(
            PostAPIServiceIntegrationInstanceRequest postAPIServiceIntegrationInstanceRequest) throws ApiException {
        return this.createApiServiceIntegrationInstance(postAPIServiceIntegrationInstanceRequest,
                Collections.emptyMap());
    }

    /**
     * Create an API Service Integration instance Creates and authorizes an API Service Integration instance
     *
     * @param postAPIServiceIntegrationInstanceRequest
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return PostAPIServiceIntegrationInstance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PostAPIServiceIntegrationInstance createApiServiceIntegrationInstance(
            PostAPIServiceIntegrationInstanceRequest postAPIServiceIntegrationInstanceRequest,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = postAPIServiceIntegrationInstanceRequest;

        // verify the required parameter 'postAPIServiceIntegrationInstanceRequest' is set
        if (postAPIServiceIntegrationInstanceRequest == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'postAPIServiceIntegrationInstanceRequest' when calling createApiServiceIntegrationInstance");
        }

        // create path and map variables
        String localVarPath = "/integrations/api/v1/api-services";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken" };

        TypeReference<PostAPIServiceIntegrationInstance> localVarReturnType = new TypeReference<PostAPIServiceIntegrationInstance>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create an API Service Integration instance Secret Creates an API Service Integration instance Secret object with
     * a new active client secret. You can create up to two Secret objects. An error is returned if you attempt to
     * create more than two Secret objects.
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     *
     * @return APIServiceIntegrationInstanceSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public APIServiceIntegrationInstanceSecret createApiServiceIntegrationInstanceSecret(String apiServiceId)
            throws ApiException {
        return this.createApiServiceIntegrationInstanceSecret(apiServiceId, Collections.emptyMap());
    }

    /**
     * Create an API Service Integration instance Secret Creates an API Service Integration instance Secret object with
     * a new active client secret. You can create up to two Secret objects. An error is returned if you attempt to
     * create more than two Secret objects.
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return APIServiceIntegrationInstanceSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public APIServiceIntegrationInstanceSecret createApiServiceIntegrationInstanceSecret(String apiServiceId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'apiServiceId' is set
        if (apiServiceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'apiServiceId' when calling createApiServiceIntegrationInstanceSecret");
        }

        // create path and map variables
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}/credentials/secrets"
                .replaceAll("\\{" + "apiServiceId" + "\\}", apiClient.escapeString(apiServiceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<APIServiceIntegrationInstanceSecret> localVarReturnType = new TypeReference<APIServiceIntegrationInstanceSecret>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate an API Service Integration instance Secret Deactivates an API Service Integration instance Secret by
     * &#x60;secretId&#x60;
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     * @param secretId
     *            &#x60;id&#x60; of the API Service Integration instance Secret (required)
     *
     * @return APIServiceIntegrationInstanceSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public APIServiceIntegrationInstanceSecret deactivateApiServiceIntegrationInstanceSecret(String apiServiceId,
            String secretId) throws ApiException {
        return this.deactivateApiServiceIntegrationInstanceSecret(apiServiceId, secretId, Collections.emptyMap());
    }

    /**
     * Deactivate an API Service Integration instance Secret Deactivates an API Service Integration instance Secret by
     * &#x60;secretId&#x60;
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     * @param secretId
     *            &#x60;id&#x60; of the API Service Integration instance Secret (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return APIServiceIntegrationInstanceSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public APIServiceIntegrationInstanceSecret deactivateApiServiceIntegrationInstanceSecret(String apiServiceId,
            String secretId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'apiServiceId' is set
        if (apiServiceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'apiServiceId' when calling deactivateApiServiceIntegrationInstanceSecret");
        }

        // verify the required parameter 'secretId' is set
        if (secretId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'secretId' when calling deactivateApiServiceIntegrationInstanceSecret");
        }

        // create path and map variables
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}/credentials/secrets/{secretId}/lifecycle/deactivate"
                .replaceAll("\\{" + "apiServiceId" + "\\}", apiClient.escapeString(apiServiceId.toString()))
                .replaceAll("\\{" + "secretId" + "\\}", apiClient.escapeString(secretId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<APIServiceIntegrationInstanceSecret> localVarReturnType = new TypeReference<APIServiceIntegrationInstanceSecret>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete an API Service Integration instance Deletes an API Service Integration instance by &#x60;id&#x60;. This
     * operation also revokes access to scopes that were previously granted to this API Service Integration instance.
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteApiServiceIntegrationInstance(String apiServiceId) throws ApiException {
        this.deleteApiServiceIntegrationInstance(apiServiceId, Collections.emptyMap());
    }

    /**
     * Delete an API Service Integration instance Deletes an API Service Integration instance by &#x60;id&#x60;. This
     * operation also revokes access to scopes that were previously granted to this API Service Integration instance.
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteApiServiceIntegrationInstance(String apiServiceId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'apiServiceId' is set
        if (apiServiceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'apiServiceId' when calling deleteApiServiceIntegrationInstance");
        }

        // create path and map variables
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}"
                .replaceAll("\\{" + "apiServiceId" + "\\}", apiClient.escapeString(apiServiceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete an API Service Integration instance Secret Deletes an API Service Integration instance Secret by
     * &#x60;secretId&#x60;. You can only delete an inactive Secret.
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     * @param secretId
     *            &#x60;id&#x60; of the API Service Integration instance Secret (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteApiServiceIntegrationInstanceSecret(String apiServiceId, String secretId) throws ApiException {
        this.deleteApiServiceIntegrationInstanceSecret(apiServiceId, secretId, Collections.emptyMap());
    }

    /**
     * Delete an API Service Integration instance Secret Deletes an API Service Integration instance Secret by
     * &#x60;secretId&#x60;. You can only delete an inactive Secret.
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     * @param secretId
     *            &#x60;id&#x60; of the API Service Integration instance Secret (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteApiServiceIntegrationInstanceSecret(String apiServiceId, String secretId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'apiServiceId' is set
        if (apiServiceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'apiServiceId' when calling deleteApiServiceIntegrationInstanceSecret");
        }

        // verify the required parameter 'secretId' is set
        if (secretId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'secretId' when calling deleteApiServiceIntegrationInstanceSecret");
        }

        // create path and map variables
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}/credentials/secrets/{secretId}"
                .replaceAll("\\{" + "apiServiceId" + "\\}", apiClient.escapeString(apiServiceId.toString()))
                .replaceAll("\\{" + "secretId" + "\\}", apiClient.escapeString(secretId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve an API Service Integration instance Retrieves an API Service Integration instance by &#x60;id&#x60;
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     *
     * @return APIServiceIntegrationInstance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public APIServiceIntegrationInstance getApiServiceIntegrationInstance(String apiServiceId) throws ApiException {
        return this.getApiServiceIntegrationInstance(apiServiceId, Collections.emptyMap());
    }

    /**
     * Retrieve an API Service Integration instance Retrieves an API Service Integration instance by &#x60;id&#x60;
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return APIServiceIntegrationInstance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public APIServiceIntegrationInstance getApiServiceIntegrationInstance(String apiServiceId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'apiServiceId' is set
        if (apiServiceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'apiServiceId' when calling getApiServiceIntegrationInstance");
        }

        // create path and map variables
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}"
                .replaceAll("\\{" + "apiServiceId" + "\\}", apiClient.escapeString(apiServiceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<APIServiceIntegrationInstance> localVarReturnType = new TypeReference<APIServiceIntegrationInstance>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all API Service Integration instance Secrets Lists all client secrets for an API Service Integration
     * instance by &#x60;apiServiceId&#x60;
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     *
     * @return List&lt;APIServiceIntegrationInstanceSecret&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<APIServiceIntegrationInstanceSecret> listApiServiceIntegrationInstanceSecrets(String apiServiceId)
            throws ApiException {
        return this.listApiServiceIntegrationInstanceSecrets(apiServiceId, Collections.emptyMap());
    }

    /**
     * List all API Service Integration instance Secrets Lists all client secrets for an API Service Integration
     * instance by &#x60;apiServiceId&#x60;
     *
     * @param apiServiceId
     *            &#x60;id&#x60; of the API Service Integration instance (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;APIServiceIntegrationInstanceSecret&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<APIServiceIntegrationInstanceSecret> listApiServiceIntegrationInstanceSecrets(String apiServiceId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'apiServiceId' is set
        if (apiServiceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'apiServiceId' when calling listApiServiceIntegrationInstanceSecrets");
        }

        // create path and map variables
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}/credentials/secrets"
                .replaceAll("\\{" + "apiServiceId" + "\\}", apiClient.escapeString(apiServiceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<APIServiceIntegrationInstanceSecret>> localVarReturnType = new TypeReference<List<APIServiceIntegrationInstanceSecret>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all API Service Integration instances Lists all API Service Integration instances with a pagination option
     *
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     *
     * @return List&lt;APIServiceIntegrationInstance&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<APIServiceIntegrationInstance> listApiServiceIntegrationInstances(String after) throws ApiException {
        return this.listApiServiceIntegrationInstances(after, Collections.emptyMap());
    }

    /**
     * List all API Service Integration instances Lists all API Service Integration instances with a pagination option
     *
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;APIServiceIntegrationInstance&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<APIServiceIntegrationInstance> listApiServiceIntegrationInstances(String after,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/integrations/api/v1/api-services";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<APIServiceIntegrationInstance>> localVarReturnType = new TypeReference<List<APIServiceIntegrationInstance>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
