/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Csr;
import com.okta.sdk.resource.model.CsrMetadata;
import com.okta.sdk.resource.model.Error;
import java.io.File;
import com.okta.sdk.resource.model.JsonWebKey;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ApplicationSsoCredentialKeyApi {

    private ApiClient apiClient;

    public ApplicationSsoCredentialKeyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationSsoCredentialKeyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Clone a Key Credential Clones an X.509 certificate for an Application Key Credential from a source app to a
     * target app. For step-by-step instructions to clone a credential, see [Share application key credentials for IdPs
     * across apps](https://developer.okta.com/docs/guides/sharing-cert/main/). &gt; **Note:** Sharing certificates
     * isn&#39;t a recommended security practice.
     *
     * @param appId
     *            Application ID (required)
     * @param keyId
     *            ID of the Key Credential for the application (required)
     * @param targetAid
     *            Unique key of the target Application (required)
     *
     * @return JsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public JsonWebKey cloneApplicationKey(String appId, String keyId, String targetAid) throws ApiException {
        return this.cloneApplicationKey(appId, keyId, targetAid, Collections.emptyMap());
    }

    /**
     * Clone a Key Credential Clones an X.509 certificate for an Application Key Credential from a source app to a
     * target app. For step-by-step instructions to clone a credential, see [Share application key credentials for IdPs
     * across apps](https://developer.okta.com/docs/guides/sharing-cert/main/). &gt; **Note:** Sharing certificates
     * isn&#39;t a recommended security practice.
     *
     * @param appId
     *            Application ID (required)
     * @param keyId
     *            ID of the Key Credential for the application (required)
     * @param targetAid
     *            Unique key of the target Application (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return JsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public JsonWebKey cloneApplicationKey(String appId, String keyId, String targetAid,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling cloneApplicationKey");
        }

        // verify the required parameter 'keyId' is set
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling cloneApplicationKey");
        }

        // verify the required parameter 'targetAid' is set
        if (targetAid == null) {
            throw new ApiException(400, "Missing the required parameter 'targetAid' when calling cloneApplicationKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/keys/{keyId}/clone"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "keyId" + "\\}", apiClient.escapeString(keyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("targetAid", targetAid));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Generate a Key Credential Generates a new X.509 certificate for an app key credential &gt; **Note:** To update an
     * Application with the newly generated key credential, use the [Replace an
     * Application](/openapi/okta-management/management/tag/Application/#tag/Application/operation/replaceApplication)
     * request with the new
     * [credentials.signing.kid](/openapi/okta-management/management/tag/Application/#tag/Application/operation/replaceApplication!path&#x3D;4/credentials/signing/kid&amp;t&#x3D;request)
     * value in the request body. You can provide just the [Signing Credential
     * object](/openapi/okta-management/management/tag/Application/#tag/Application/operation/replaceApplication!path&#x3D;4/credentials/signing&amp;t&#x3D;request)
     * instead of the entire [Application Credential
     * object](/openapi/okta-management/management/tag/Application/#tag/Application/operation/replaceApplication!path&#x3D;4/credentials&amp;t&#x3D;request).
     *
     * @param appId
     *            Application ID (required)
     * @param validityYears
     *            Expiry years of the Application Key Credential (required)
     *
     * @return JsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public JsonWebKey generateApplicationKey(String appId, Integer validityYears) throws ApiException {
        return this.generateApplicationKey(appId, validityYears, Collections.emptyMap());
    }

    /**
     * Generate a Key Credential Generates a new X.509 certificate for an app key credential &gt; **Note:** To update an
     * Application with the newly generated key credential, use the [Replace an
     * Application](/openapi/okta-management/management/tag/Application/#tag/Application/operation/replaceApplication)
     * request with the new
     * [credentials.signing.kid](/openapi/okta-management/management/tag/Application/#tag/Application/operation/replaceApplication!path&#x3D;4/credentials/signing/kid&amp;t&#x3D;request)
     * value in the request body. You can provide just the [Signing Credential
     * object](/openapi/okta-management/management/tag/Application/#tag/Application/operation/replaceApplication!path&#x3D;4/credentials/signing&amp;t&#x3D;request)
     * instead of the entire [Application Credential
     * object](/openapi/okta-management/management/tag/Application/#tag/Application/operation/replaceApplication!path&#x3D;4/credentials&amp;t&#x3D;request).
     *
     * @param appId
     *            Application ID (required)
     * @param validityYears
     *            Expiry years of the Application Key Credential (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return JsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public JsonWebKey generateApplicationKey(String appId, Integer validityYears, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling generateApplicationKey");
        }

        // verify the required parameter 'validityYears' is set
        if (validityYears == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'validityYears' when calling generateApplicationKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/keys/generate".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("validityYears", validityYears));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Generate a Certificate Signing Request Generates a new key pair and returns the Certificate Signing Request(CSR)
     * for it. The information in a CSR is used by the Certificate Authority (CA) to verify and create your certificate.
     * It also contains the public key that is included in your certificate. Returns CSR in &#x60;pkcs#10&#x60; format
     * if the &#x60;Accept&#x60; media type is &#x60;application/pkcs10&#x60; or a CSR object if the &#x60;Accept&#x60;
     * media type is &#x60;application/json&#x60;. &gt; **Note:** The key pair isn&#39;t listed in the Key Credentials
     * for the app until it&#39;s published.
     *
     * @param appId
     *            Application ID (required)
     * @param metadata
     *            (required)
     *
     * @return String
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public String generateCsrForApplication(String appId, CsrMetadata metadata) throws ApiException {
        return this.generateCsrForApplication(appId, metadata, Collections.emptyMap());
    }

    /**
     * Generate a Certificate Signing Request Generates a new key pair and returns the Certificate Signing Request(CSR)
     * for it. The information in a CSR is used by the Certificate Authority (CA) to verify and create your certificate.
     * It also contains the public key that is included in your certificate. Returns CSR in &#x60;pkcs#10&#x60; format
     * if the &#x60;Accept&#x60; media type is &#x60;application/pkcs10&#x60; or a CSR object if the &#x60;Accept&#x60;
     * media type is &#x60;application/json&#x60;. &gt; **Note:** The key pair isn&#39;t listed in the Key Credentials
     * for the app until it&#39;s published.
     *
     * @param appId
     *            Application ID (required)
     * @param metadata
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return String
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public String generateCsrForApplication(String appId, CsrMetadata metadata, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = metadata;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling generateCsrForApplication");
        }

        // verify the required parameter 'metadata' is set
        if (metadata == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'metadata' when calling generateCsrForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/csrs".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/pkcs10", "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<String> localVarReturnType = new TypeReference<String>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a Key Credential Retrieves a specific Application Key Credential by &#x60;kid&#x60;
     *
     * @param appId
     *            Application ID (required)
     * @param keyId
     *            ID of the Key Credential for the application (required)
     *
     * @return JsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public JsonWebKey getApplicationKey(String appId, String keyId) throws ApiException {
        return this.getApplicationKey(appId, keyId, Collections.emptyMap());
    }

    /**
     * Retrieve a Key Credential Retrieves a specific Application Key Credential by &#x60;kid&#x60;
     *
     * @param appId
     *            Application ID (required)
     * @param keyId
     *            ID of the Key Credential for the application (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return JsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public JsonWebKey getApplicationKey(String appId, String keyId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getApplicationKey");
        }

        // verify the required parameter 'keyId' is set
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling getApplicationKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/keys/{keyId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "keyId" + "\\}", apiClient.escapeString(keyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a Certificate Signing Request Retrieves a Certificate Signing Request (CSR) for the app by
     * &#x60;csrId&#x60;. Returns a Base64-encoded CSR in DER format if the &#x60;Accept&#x60; media type is
     * &#x60;application/pkcs10&#x60; or a CSR object if the &#x60;Accept&#x60; media type is
     * &#x60;application/json&#x60;.
     *
     * @param appId
     *            Application ID (required)
     * @param csrId
     *            &#x60;id&#x60; of the CSR (required)
     *
     * @return Csr
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Csr getCsrForApplication(String appId, String csrId) throws ApiException {
        return this.getCsrForApplication(appId, csrId, Collections.emptyMap());
    }

    /**
     * Retrieve a Certificate Signing Request Retrieves a Certificate Signing Request (CSR) for the app by
     * &#x60;csrId&#x60;. Returns a Base64-encoded CSR in DER format if the &#x60;Accept&#x60; media type is
     * &#x60;application/pkcs10&#x60; or a CSR object if the &#x60;Accept&#x60; media type is
     * &#x60;application/json&#x60;.
     *
     * @param appId
     *            Application ID (required)
     * @param csrId
     *            &#x60;id&#x60; of the CSR (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Csr
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Csr getCsrForApplication(String appId, String csrId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getCsrForApplication");
        }

        // verify the required parameter 'csrId' is set
        if (csrId == null) {
            throw new ApiException(400, "Missing the required parameter 'csrId' when calling getCsrForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/csrs/{csrId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "csrId" + "\\}", apiClient.escapeString(csrId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json", "application/pkcs10" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Csr> localVarReturnType = new TypeReference<Csr>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Key Credentials Lists all key credentials for an app
     *
     * @param appId
     *            Application ID (required)
     *
     * @return List&lt;JsonWebKey&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<JsonWebKey> listApplicationKeys(String appId) throws ApiException {
        return this.listApplicationKeys(appId, Collections.emptyMap());
    }

    /**
     * List all Key Credentials Lists all key credentials for an app
     *
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;JsonWebKey&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<JsonWebKey> listApplicationKeys(String appId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listApplicationKeys");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/keys".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<JsonWebKey>> localVarReturnType = new TypeReference<List<JsonWebKey>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Certificate Signing Requests Lists all Certificate Signing Requests for an application
     *
     * @param appId
     *            Application ID (required)
     *
     * @return List&lt;Csr&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Csr> listCsrsForApplication(String appId) throws ApiException {
        return this.listCsrsForApplication(appId, Collections.emptyMap());
    }

    /**
     * List all Certificate Signing Requests Lists all Certificate Signing Requests for an application
     *
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;Csr&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Csr> listCsrsForApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listCsrsForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/csrs".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<Csr>> localVarReturnType = new TypeReference<List<Csr>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Publish a Certificate Signing Request Publishes a Certificate Signing Request (CSR) for the app with a signed
     * X.509 certificate and adds it into the Application Key Credentials. &gt; **Note:** Publishing a certificate
     * completes the lifecycle of the CSR and it&#39;s no longer accessible.
     *
     * @param appId
     *            Application ID (required)
     * @param csrId
     *            &#x60;id&#x60; of the CSR (required)
     * @param body
     *            (required)
     *
     * @return JsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public JsonWebKey publishCsrFromApplication(String appId, String csrId, File body) throws ApiException {
        return this.publishCsrFromApplication(appId, csrId, body, Collections.emptyMap());
    }

    /**
     * Publish a Certificate Signing Request Publishes a Certificate Signing Request (CSR) for the app with a signed
     * X.509 certificate and adds it into the Application Key Credentials. &gt; **Note:** Publishing a certificate
     * completes the lifecycle of the CSR and it&#39;s no longer accessible.
     *
     * @param appId
     *            Application ID (required)
     * @param csrId
     *            &#x60;id&#x60; of the CSR (required)
     * @param body
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return JsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public JsonWebKey publishCsrFromApplication(String appId, String csrId, File body,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling publishCsrFromApplication");
        }

        // verify the required parameter 'csrId' is set
        if (csrId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'csrId' when calling publishCsrFromApplication");
        }

        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling publishCsrFromApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/csrs/{csrId}/lifecycle/publish"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "csrId" + "\\}", apiClient.escapeString(csrId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/x-x509-ca-cert", "application/pkix-cert",
                "application/x-pem-file" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<JsonWebKey> localVarReturnType = new TypeReference<JsonWebKey>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Revoke a Certificate Signing Request Revokes a Certificate Signing Request and deletes the key pair from the app
     *
     * @param appId
     *            Application ID (required)
     * @param csrId
     *            &#x60;id&#x60; of the CSR (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeCsrFromApplication(String appId, String csrId) throws ApiException {
        this.revokeCsrFromApplication(appId, csrId, Collections.emptyMap());
    }

    /**
     * Revoke a Certificate Signing Request Revokes a Certificate Signing Request and deletes the key pair from the app
     *
     * @param appId
     *            Application ID (required)
     * @param csrId
     *            &#x60;id&#x60; of the CSR (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeCsrFromApplication(String appId, String csrId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling revokeCsrFromApplication");
        }

        // verify the required parameter 'csrId' is set
        if (csrId == null) {
            throw new ApiException(400, "Missing the required parameter 'csrId' when calling revokeCsrFromApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/csrs/{csrId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "csrId" + "\\}", apiClient.escapeString(csrId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
