/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AttackProtectionAuthenticatorSettings;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.UserLockoutSettings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AttackProtectionApi {

    private ApiClient apiClient;

    public AttackProtectionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AttackProtectionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve the Authenticator Settings Retrieves the Authenticator Settings for an org
     *
     * @return List&lt;AttackProtectionAuthenticatorSettings&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AttackProtectionAuthenticatorSettings> getAuthenticatorSettings() throws ApiException {
        return this.getAuthenticatorSettings(Collections.emptyMap());
    }

    /**
     * Retrieve the Authenticator Settings Retrieves the Authenticator Settings for an org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;AttackProtectionAuthenticatorSettings&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AttackProtectionAuthenticatorSettings> getAuthenticatorSettings(Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/attack-protection/api/v1/authenticator-settings";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<AttackProtectionAuthenticatorSettings>> localVarReturnType = new TypeReference<List<AttackProtectionAuthenticatorSettings>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve the User Lockout Settings Retrieves the User Lockout Settings for an org
     *
     * @return List&lt;UserLockoutSettings&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserLockoutSettings> getUserLockoutSettings() throws ApiException {
        return this.getUserLockoutSettings(Collections.emptyMap());
    }

    /**
     * Retrieve the User Lockout Settings Retrieves the User Lockout Settings for an org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;UserLockoutSettings&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserLockoutSettings> getUserLockoutSettings(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/attack-protection/api/v1/user-lockout-settings";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<UserLockoutSettings>> localVarReturnType = new TypeReference<List<UserLockoutSettings>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace the Authenticator Settings Replaces the Authenticator Settings for an org
     *
     * @param authenticatorSettings
     *            (required)
     *
     * @return AttackProtectionAuthenticatorSettings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AttackProtectionAuthenticatorSettings replaceAuthenticatorSettings(
            AttackProtectionAuthenticatorSettings authenticatorSettings) throws ApiException {
        return this.replaceAuthenticatorSettings(authenticatorSettings, Collections.emptyMap());
    }

    /**
     * Replace the Authenticator Settings Replaces the Authenticator Settings for an org
     *
     * @param authenticatorSettings
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AttackProtectionAuthenticatorSettings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AttackProtectionAuthenticatorSettings replaceAuthenticatorSettings(
            AttackProtectionAuthenticatorSettings authenticatorSettings, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = authenticatorSettings;

        // verify the required parameter 'authenticatorSettings' is set
        if (authenticatorSettings == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authenticatorSettings' when calling replaceAuthenticatorSettings");
        }

        // create path and map variables
        String localVarPath = "/attack-protection/api/v1/authenticator-settings";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AttackProtectionAuthenticatorSettings> localVarReturnType = new TypeReference<AttackProtectionAuthenticatorSettings>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace the User Lockout Settings Replaces the User Lockout Settings for an org
     *
     * @param lockoutSettings
     *            (required)
     *
     * @return UserLockoutSettings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserLockoutSettings replaceUserLockoutSettings(UserLockoutSettings lockoutSettings) throws ApiException {
        return this.replaceUserLockoutSettings(lockoutSettings, Collections.emptyMap());
    }

    /**
     * Replace the User Lockout Settings Replaces the User Lockout Settings for an org
     *
     * @param lockoutSettings
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserLockoutSettings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserLockoutSettings replaceUserLockoutSettings(UserLockoutSettings lockoutSettings,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = lockoutSettings;

        // verify the required parameter 'lockoutSettings' is set
        if (lockoutSettings == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'lockoutSettings' when calling replaceUserLockoutSettings");
        }

        // create path and map variables
        String localVarPath = "/attack-protection/api/v1/user-lockout-settings";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserLockoutSettings> localVarReturnType = new TypeReference<UserLockoutSettings>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
