/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OAuth2Client;
import com.okta.sdk.resource.model.OAuth2RefreshToken;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthorizationServerClientsApi {

    private ApiClient apiClient;

    public AuthorizationServerClientsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerClientsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve a refresh token for a Client Retrieves a refresh token for a Client
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param tokenId
     *            &#x60;id&#x60; of Token (required)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     *
     * @return OAuth2RefreshToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2RefreshToken getRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId,
            String tokenId, String expand) throws ApiException {
        return this.getRefreshTokenForAuthorizationServerAndClient(authServerId, clientId, tokenId, expand,
                Collections.emptyMap());
    }

    /**
     * Retrieve a refresh token for a Client Retrieves a refresh token for a Client
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param tokenId
     *            &#x60;id&#x60; of Token (required)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2RefreshToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2RefreshToken getRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId,
            String tokenId, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling getRefreshTokenForAuthorizationServerAndClient");
        }

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling getRefreshTokenForAuthorizationServerAndClient");
        }

        // verify the required parameter 'tokenId' is set
        if (tokenId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'tokenId' when calling getRefreshTokenForAuthorizationServerAndClient");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "tokenId" + "\\}", apiClient.escapeString(tokenId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2RefreshToken> localVarReturnType = new TypeReference<OAuth2RefreshToken>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Client resources for an authorization server Lists all Client resources for which the specified
     * authorization server has tokens
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     *
     * @return List&lt;OAuth2Client&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2Client> listOAuth2ClientsForAuthorizationServer(String authServerId) throws ApiException {
        return this.listOAuth2ClientsForAuthorizationServer(authServerId, Collections.emptyMap());
    }

    /**
     * List all Client resources for an authorization server Lists all Client resources for which the specified
     * authorization server has tokens
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;OAuth2Client&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2Client> listOAuth2ClientsForAuthorizationServer(String authServerId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling listOAuth2ClientsForAuthorizationServer");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/clients"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<OAuth2Client>> localVarReturnType = new TypeReference<List<OAuth2Client>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all refresh tokens for a Client Lists all refresh tokens issued by an authorization server for a specific
     * Client
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     * @param after
     *            Specifies the pagination cursor for the next page of tokens (optional)
     * @param limit
     *            The maximum number of tokens to return (maximum 200) (optional, default to -1)
     *
     * @return List&lt;OAuth2RefreshToken&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2RefreshToken> listRefreshTokensForAuthorizationServerAndClient(String authServerId,
            String clientId, String expand, String after, Integer limit) throws ApiException {
        return this.listRefreshTokensForAuthorizationServerAndClient(authServerId, clientId, expand, after, limit,
                Collections.emptyMap());
    }

    /**
     * List all refresh tokens for a Client Lists all refresh tokens issued by an authorization server for a specific
     * Client
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     * @param after
     *            Specifies the pagination cursor for the next page of tokens (optional)
     * @param limit
     *            The maximum number of tokens to return (maximum 200) (optional, default to -1)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;OAuth2RefreshToken&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2RefreshToken> listRefreshTokensForAuthorizationServerAndClient(String authServerId,
            String clientId, String expand, String after, Integer limit, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling listRefreshTokensForAuthorizationServerAndClient");
        }

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling listRefreshTokensForAuthorizationServerAndClient");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<OAuth2RefreshToken>> localVarReturnType = new TypeReference<List<OAuth2RefreshToken>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Revoke a refresh token for a Client Revokes a refresh token for a Client
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param tokenId
     *            &#x60;id&#x60; of Token (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId, String tokenId)
            throws ApiException {
        this.revokeRefreshTokenForAuthorizationServerAndClient(authServerId, clientId, tokenId, Collections.emptyMap());
    }

    /**
     * Revoke a refresh token for a Client Revokes a refresh token for a Client
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param tokenId
     *            &#x60;id&#x60; of Token (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId, String tokenId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling revokeRefreshTokenForAuthorizationServerAndClient");
        }

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling revokeRefreshTokenForAuthorizationServerAndClient");
        }

        // verify the required parameter 'tokenId' is set
        if (tokenId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'tokenId' when calling revokeRefreshTokenForAuthorizationServerAndClient");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "tokenId" + "\\}", apiClient.escapeString(tokenId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Revoke all refresh tokens for a Client Revokes all refresh tokens for a Client
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeRefreshTokensForAuthorizationServerAndClient(String authServerId, String clientId)
            throws ApiException {
        this.revokeRefreshTokensForAuthorizationServerAndClient(authServerId, clientId, Collections.emptyMap());
    }

    /**
     * Revoke all refresh tokens for a Client Revokes all refresh tokens for a Client
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeRefreshTokensForAuthorizationServerAndClient(String authServerId, String clientId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling revokeRefreshTokensForAuthorizationServerAndClient");
        }

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling revokeRefreshTokensForAuthorizationServerAndClient");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
