/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.DeviceAssurance;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class DeviceAssuranceApi {

    private ApiClient apiClient;

    public DeviceAssuranceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeviceAssuranceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a Device Assurance Policy Creates a new Device Assurance Policy
     *
     * @param deviceAssurance
     *            (required)
     *
     * @return DeviceAssurance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DeviceAssurance createDeviceAssurancePolicy(DeviceAssurance deviceAssurance) throws ApiException {
        return this.createDeviceAssurancePolicy(deviceAssurance, Collections.emptyMap());
    }

    /**
     * Create a Device Assurance Policy Creates a new Device Assurance Policy
     *
     * @param deviceAssurance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return DeviceAssurance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DeviceAssurance createDeviceAssurancePolicy(DeviceAssurance deviceAssurance,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = deviceAssurance;

        // verify the required parameter 'deviceAssurance' is set
        if (deviceAssurance == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'deviceAssurance' when calling createDeviceAssurancePolicy");
        }

        // create path and map variables
        String localVarPath = "/api/v1/device-assurances";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<DeviceAssurance> localVarReturnType = new TypeReference<DeviceAssurance>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Device Assurance Policy Deletes a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;. If the
     * Device Assurance Policy is currently being used in the org Authentication Policies, the delete will not be
     * allowed.
     *
     * @param deviceAssuranceId
     *            Id of the Device Assurance Policy (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteDeviceAssurancePolicy(String deviceAssuranceId) throws ApiException {
        this.deleteDeviceAssurancePolicy(deviceAssuranceId, Collections.emptyMap());
    }

    /**
     * Delete a Device Assurance Policy Deletes a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;. If the
     * Device Assurance Policy is currently being used in the org Authentication Policies, the delete will not be
     * allowed.
     *
     * @param deviceAssuranceId
     *            Id of the Device Assurance Policy (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteDeviceAssurancePolicy(String deviceAssuranceId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'deviceAssuranceId' is set
        if (deviceAssuranceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'deviceAssuranceId' when calling deleteDeviceAssurancePolicy");
        }

        // create path and map variables
        String localVarPath = "/api/v1/device-assurances/{deviceAssuranceId}"
                .replaceAll("\\{" + "deviceAssuranceId" + "\\}", apiClient.escapeString(deviceAssuranceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Device Assurance Policy Retrieves a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;
     *
     * @param deviceAssuranceId
     *            Id of the Device Assurance Policy (required)
     *
     * @return DeviceAssurance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DeviceAssurance getDeviceAssurancePolicy(String deviceAssuranceId) throws ApiException {
        return this.getDeviceAssurancePolicy(deviceAssuranceId, Collections.emptyMap());
    }

    /**
     * Retrieve a Device Assurance Policy Retrieves a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;
     *
     * @param deviceAssuranceId
     *            Id of the Device Assurance Policy (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return DeviceAssurance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DeviceAssurance getDeviceAssurancePolicy(String deviceAssuranceId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'deviceAssuranceId' is set
        if (deviceAssuranceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'deviceAssuranceId' when calling getDeviceAssurancePolicy");
        }

        // create path and map variables
        String localVarPath = "/api/v1/device-assurances/{deviceAssuranceId}"
                .replaceAll("\\{" + "deviceAssuranceId" + "\\}", apiClient.escapeString(deviceAssuranceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<DeviceAssurance> localVarReturnType = new TypeReference<DeviceAssurance>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Device Assurance Policies Lists all device assurance policies
     *
     * @return List&lt;DeviceAssurance&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<DeviceAssurance> listDeviceAssurancePolicies() throws ApiException {
        return this.listDeviceAssurancePolicies(Collections.emptyMap());
    }

    /**
     * List all Device Assurance Policies Lists all device assurance policies
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;DeviceAssurance&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<DeviceAssurance> listDeviceAssurancePolicies(Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/device-assurances";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<DeviceAssurance>> localVarReturnType = new TypeReference<List<DeviceAssurance>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Device Assurance Policy Replaces a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;
     *
     * @param deviceAssuranceId
     *            Id of the Device Assurance Policy (required)
     * @param deviceAssurance
     *            (required)
     *
     * @return DeviceAssurance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DeviceAssurance replaceDeviceAssurancePolicy(String deviceAssuranceId, DeviceAssurance deviceAssurance)
            throws ApiException {
        return this.replaceDeviceAssurancePolicy(deviceAssuranceId, deviceAssurance, Collections.emptyMap());
    }

    /**
     * Replace a Device Assurance Policy Replaces a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;
     *
     * @param deviceAssuranceId
     *            Id of the Device Assurance Policy (required)
     * @param deviceAssurance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return DeviceAssurance
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DeviceAssurance replaceDeviceAssurancePolicy(String deviceAssuranceId, DeviceAssurance deviceAssurance,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = deviceAssurance;

        // verify the required parameter 'deviceAssuranceId' is set
        if (deviceAssuranceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'deviceAssuranceId' when calling replaceDeviceAssurancePolicy");
        }

        // verify the required parameter 'deviceAssurance' is set
        if (deviceAssurance == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'deviceAssurance' when calling replaceDeviceAssurancePolicy");
        }

        // create path and map variables
        String localVarPath = "/api/v1/device-assurances/{deviceAssuranceId}"
                .replaceAll("\\{" + "deviceAssuranceId" + "\\}", apiClient.escapeString(deviceAssuranceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<DeviceAssurance> localVarReturnType = new TypeReference<DeviceAssurance>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
