/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.EmailServerListResponse;
import com.okta.sdk.resource.model.EmailServerPost;
import com.okta.sdk.resource.model.EmailServerRequest;
import com.okta.sdk.resource.model.EmailServerResponse;
import com.okta.sdk.resource.model.EmailTestAddresses;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class EmailServerApi {

    private ApiClient apiClient;

    public EmailServerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EmailServerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a custom SMTP server Creates a custom email SMTP server configuration for your org
     *
     * @param emailServerPost
     *            (optional)
     *
     * @return EmailServerResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailServerResponse createEmailServer(EmailServerPost emailServerPost) throws ApiException {
        return this.createEmailServer(emailServerPost, Collections.emptyMap());
    }

    /**
     * Create a custom SMTP server Creates a custom email SMTP server configuration for your org
     *
     * @param emailServerPost
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EmailServerResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailServerResponse createEmailServer(EmailServerPost emailServerPost, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = emailServerPost;

        // create path and map variables
        String localVarPath = "/api/v1/email-servers";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EmailServerResponse> localVarReturnType = new TypeReference<EmailServerResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete an SMTP Server configuration Deletes the specified custom SMTP server configuration
     *
     * @param emailServerId
     *            (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteEmailServer(String emailServerId) throws ApiException {
        this.deleteEmailServer(emailServerId, Collections.emptyMap());
    }

    /**
     * Delete an SMTP Server configuration Deletes the specified custom SMTP server configuration
     *
     * @param emailServerId
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteEmailServer(String emailServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'emailServerId' is set
        if (emailServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'emailServerId' when calling deleteEmailServer");
        }

        // create path and map variables
        String localVarPath = "/api/v1/email-servers/{emailServerId}".replaceAll("\\{" + "emailServerId" + "\\}",
                apiClient.escapeString(emailServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve an SMTP Server configuration Retrieves the specified custom SMTP server configuration
     *
     * @param emailServerId
     *            (required)
     *
     * @return EmailServerListResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailServerListResponse getEmailServer(String emailServerId) throws ApiException {
        return this.getEmailServer(emailServerId, Collections.emptyMap());
    }

    /**
     * Retrieve an SMTP Server configuration Retrieves the specified custom SMTP server configuration
     *
     * @param emailServerId
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EmailServerListResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailServerListResponse getEmailServer(String emailServerId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'emailServerId' is set
        if (emailServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'emailServerId' when calling getEmailServer");
        }

        // create path and map variables
        String localVarPath = "/api/v1/email-servers/{emailServerId}".replaceAll("\\{" + "emailServerId" + "\\}",
                apiClient.escapeString(emailServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EmailServerListResponse> localVarReturnType = new TypeReference<EmailServerListResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all enrolled SMTP servers Lists all the enrolled custom SMTP server configurations
     *
     * @return EmailServerListResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailServerListResponse listEmailServers() throws ApiException {
        return this.listEmailServers(Collections.emptyMap());
    }

    /**
     * List all enrolled SMTP servers Lists all the enrolled custom SMTP server configurations
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EmailServerListResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailServerListResponse listEmailServers(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/email-servers";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EmailServerListResponse> localVarReturnType = new TypeReference<EmailServerListResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Test an SMTP Server configuration Tests the specified custom SMTP Server configuration
     *
     * @param emailServerId
     *            (required)
     * @param emailTestAddresses
     *            (optional)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void testEmailServer(String emailServerId, EmailTestAddresses emailTestAddresses) throws ApiException {
        this.testEmailServer(emailServerId, emailTestAddresses, Collections.emptyMap());
    }

    /**
     * Test an SMTP Server configuration Tests the specified custom SMTP Server configuration
     *
     * @param emailServerId
     *            (required)
     * @param emailTestAddresses
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void testEmailServer(String emailServerId, EmailTestAddresses emailTestAddresses,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = emailTestAddresses;

        // verify the required parameter 'emailServerId' is set
        if (emailServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'emailServerId' when calling testEmailServer");
        }

        // create path and map variables
        String localVarPath = "/api/v1/email-servers/{emailServerId}/test".replaceAll("\\{" + "emailServerId" + "\\}",
                apiClient.escapeString(emailServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Update an SMTP Server configuration Updates the specified custom SMTP server configuration
     *
     * @param emailServerId
     *            (required)
     * @param emailServerRequest
     *            (optional)
     *
     * @return EmailServerResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailServerResponse updateEmailServer(String emailServerId, EmailServerRequest emailServerRequest)
            throws ApiException {
        return this.updateEmailServer(emailServerId, emailServerRequest, Collections.emptyMap());
    }

    /**
     * Update an SMTP Server configuration Updates the specified custom SMTP server configuration
     *
     * @param emailServerId
     *            (required)
     * @param emailServerRequest
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EmailServerResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailServerResponse updateEmailServer(String emailServerId, EmailServerRequest emailServerRequest,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = emailServerRequest;

        // verify the required parameter 'emailServerId' is set
        if (emailServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'emailServerId' when calling updateEmailServer");
        }

        // create path and map variables
        String localVarPath = "/api/v1/email-servers/{emailServerId}".replaceAll("\\{" + "emailServerId" + "\\}",
                apiClient.escapeString(emailServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EmailServerResponse> localVarReturnType = new TypeReference<EmailServerResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
