/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.IdentityProvider;
import com.okta.sdk.resource.model.IdentityProviderApplicationUser;
import com.okta.sdk.resource.model.SocialAuthToken;
import com.okta.sdk.resource.model.UserIdentityProviderLinkRequest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class IdentityProviderUsersApi {

    private ApiClient apiClient;

    public IdentityProviderUsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IdentityProviderUsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve a User for IdP Retrieves a linked IdP User by ID
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @return IdentityProviderApplicationUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProviderApplicationUser getIdentityProviderApplicationUser(String idpId, String userId)
            throws ApiException {
        return this.getIdentityProviderApplicationUser(idpId, userId, Collections.emptyMap());
    }

    /**
     * Retrieve a User for IdP Retrieves a linked IdP User by ID
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdentityProviderApplicationUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProviderApplicationUser getIdentityProviderApplicationUser(String idpId, String userId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpId' when calling getIdentityProviderApplicationUser");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling getIdentityProviderApplicationUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/users/{userId}"
                .replaceAll("\\{" + "idpId" + "\\}", apiClient.escapeString(idpId.toString()))
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdentityProviderApplicationUser> localVarReturnType = new TypeReference<IdentityProviderApplicationUser>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Link a User to IdP Links an Okta User to an existing SAML or social Identity Provider. The SAML Identity Provider
     * must have &#x60;honorPersistentNameId&#x60; set to &#x60;true&#x60; to use this API. The [Name Identifier
     * Format](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/replaceIdentityProvider!path&#x3D;protocol/0/settings&amp;t&#x3D;request)
     * of the incoming assertion must be &#x60;urn:oasis:names:tc:SAML:2.0:nameid-format:persistent&#x60;.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param userIdentityProviderLinkRequest
     *            (required)
     *
     * @return IdentityProviderApplicationUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProviderApplicationUser linkUserToIdentityProvider(String idpId, String userId,
            UserIdentityProviderLinkRequest userIdentityProviderLinkRequest) throws ApiException {
        return this.linkUserToIdentityProvider(idpId, userId, userIdentityProviderLinkRequest, Collections.emptyMap());
    }

    /**
     * Link a User to IdP Links an Okta User to an existing SAML or social Identity Provider. The SAML Identity Provider
     * must have &#x60;honorPersistentNameId&#x60; set to &#x60;true&#x60; to use this API. The [Name Identifier
     * Format](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/replaceIdentityProvider!path&#x3D;protocol/0/settings&amp;t&#x3D;request)
     * of the incoming assertion must be &#x60;urn:oasis:names:tc:SAML:2.0:nameid-format:persistent&#x60;.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param userIdentityProviderLinkRequest
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdentityProviderApplicationUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProviderApplicationUser linkUserToIdentityProvider(String idpId, String userId,
            UserIdentityProviderLinkRequest userIdentityProviderLinkRequest, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = userIdentityProviderLinkRequest;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpId' when calling linkUserToIdentityProvider");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling linkUserToIdentityProvider");
        }

        // verify the required parameter 'userIdentityProviderLinkRequest' is set
        if (userIdentityProviderLinkRequest == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userIdentityProviderLinkRequest' when calling linkUserToIdentityProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/users/{userId}"
                .replaceAll("\\{" + "idpId" + "\\}", apiClient.escapeString(idpId.toString()))
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdentityProviderApplicationUser> localVarReturnType = new TypeReference<IdentityProviderApplicationUser>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Users for IdP Lists all the Users linked to an Identity Provider
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param q
     *            Searches the records for matching value (optional)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param expand
     *            Expand user data (optional)
     *
     * @return List&lt;IdentityProviderApplicationUser&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdentityProviderApplicationUser> listIdentityProviderApplicationUsers(String idpId, String q,
            String after, Integer limit, String expand) throws ApiException {
        return this.listIdentityProviderApplicationUsers(idpId, q, after, limit, expand, Collections.emptyMap());
    }

    /**
     * List all Users for IdP Lists all the Users linked to an Identity Provider
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param q
     *            Searches the records for matching value (optional)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param expand
     *            Expand user data (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;IdentityProviderApplicationUser&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdentityProviderApplicationUser> listIdentityProviderApplicationUsers(String idpId, String q,
            String after, Integer limit, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpId' when calling listIdentityProviderApplicationUsers");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/users".replaceAll("\\{" + "idpId" + "\\}",
                apiClient.escapeString(idpId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<IdentityProviderApplicationUser>> localVarReturnType = new TypeReference<List<IdentityProviderApplicationUser>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Tokens from OIDC IdP Lists the tokens minted by the Social Authentication Provider when the user
     * authenticates with Okta via Social Auth. Okta doesn&#39;t import all the User information from a social provider.
     * If the app needs information that isn&#39;t imported, it can get the User token from this endpoint. Then the app
     * can make an API call to the social provider with the token to request the additional information.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @return List&lt;SocialAuthToken&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<SocialAuthToken> listSocialAuthTokens(String idpId, String userId) throws ApiException {
        return this.listSocialAuthTokens(idpId, userId, Collections.emptyMap());
    }

    /**
     * List all Tokens from OIDC IdP Lists the tokens minted by the Social Authentication Provider when the user
     * authenticates with Okta via Social Auth. Okta doesn&#39;t import all the User information from a social provider.
     * If the app needs information that isn&#39;t imported, it can get the User token from this endpoint. Then the app
     * can make an API call to the social provider with the token to request the additional information.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;SocialAuthToken&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<SocialAuthToken> listSocialAuthTokens(String idpId, String userId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling listSocialAuthTokens");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listSocialAuthTokens");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/users/{userId}/credentials/tokens"
                .replaceAll("\\{" + "idpId" + "\\}", apiClient.escapeString(idpId.toString()))
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<SocialAuthToken>> localVarReturnType = new TypeReference<List<SocialAuthToken>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Identity Providers for User Lists the IdPs associated with the User
     *
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @return List&lt;IdentityProvider&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdentityProvider> listUserIdentityProviders(String userId) throws ApiException {
        return this.listUserIdentityProviders(userId, Collections.emptyMap());
    }

    /**
     * List all Identity Providers for User Lists the IdPs associated with the User
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;IdentityProvider&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdentityProvider> listUserIdentityProviders(String userId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling listUserIdentityProviders");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/idps".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<IdentityProvider>> localVarReturnType = new TypeReference<List<IdentityProvider>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Unlink a User from IdP Unlinks the Okta User and the IdP User. The next time the User federates into Okta through
     * this IdP, they have to re-link their account according to the account link policy.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unlinkUserFromIdentityProvider(String idpId, String userId) throws ApiException {
        this.unlinkUserFromIdentityProvider(idpId, userId, Collections.emptyMap());
    }

    /**
     * Unlink a User from IdP Unlinks the Okta User and the IdP User. The next time the User federates into Okta through
     * this IdP, they have to re-link their account according to the account link policy.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unlinkUserFromIdentityProvider(String idpId, String userId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpId' when calling unlinkUserFromIdentityProvider");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling unlinkUserFromIdentityProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/users/{userId}"
                .replaceAll("\\{" + "idpId" + "\\}", apiClient.escapeString(idpId.toString()))
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
