/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AdminConsoleSettings;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OktaApplicationSettingsApi {

    private ApiClient apiClient;

    public OktaApplicationSettingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OktaApplicationSettingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve the Okta Application Settings Retrieves the settings for an Okta app (also known as an Okta first-party
     * app)
     *
     * @param appName
     *            The key name for the Okta app.&lt;br&gt; Supported apps: * Okta Admin Console
     *            (&#x60;admin-console&#x60;) (required)
     *
     * @return AdminConsoleSettings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AdminConsoleSettings getFirstPartyAppSettings(String appName) throws ApiException {
        return this.getFirstPartyAppSettings(appName, Collections.emptyMap());
    }

    /**
     * Retrieve the Okta Application Settings Retrieves the settings for an Okta app (also known as an Okta first-party
     * app)
     *
     * @param appName
     *            The key name for the Okta app.&lt;br&gt; Supported apps: * Okta Admin Console
     *            (&#x60;admin-console&#x60;) (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AdminConsoleSettings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AdminConsoleSettings getFirstPartyAppSettings(String appName, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appName' is set
        if (appName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appName' when calling getFirstPartyAppSettings");
        }

        // create path and map variables
        String localVarPath = "/api/v1/first-party-app-settings/{appName}".replaceAll("\\{" + "appName" + "\\}",
                apiClient.escapeString(appName.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AdminConsoleSettings> localVarReturnType = new TypeReference<AdminConsoleSettings>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace the Okta Application Settings Replaces the settings for an Okta app (also known as an Okta first-party
     * app)
     *
     * @param appName
     *            The key name for the Okta app.&lt;br&gt; Supported apps: * Okta Admin Console
     *            (&#x60;admin-console&#x60;) (required)
     * @param adminConsoleSettings
     *            (required)
     *
     * @return AdminConsoleSettings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AdminConsoleSettings replaceFirstPartyAppSettings(String appName, AdminConsoleSettings adminConsoleSettings)
            throws ApiException {
        return this.replaceFirstPartyAppSettings(appName, adminConsoleSettings, Collections.emptyMap());
    }

    /**
     * Replace the Okta Application Settings Replaces the settings for an Okta app (also known as an Okta first-party
     * app)
     *
     * @param appName
     *            The key name for the Okta app.&lt;br&gt; Supported apps: * Okta Admin Console
     *            (&#x60;admin-console&#x60;) (required)
     * @param adminConsoleSettings
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AdminConsoleSettings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AdminConsoleSettings replaceFirstPartyAppSettings(String appName, AdminConsoleSettings adminConsoleSettings,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = adminConsoleSettings;

        // verify the required parameter 'appName' is set
        if (appName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appName' when calling replaceFirstPartyAppSettings");
        }

        // verify the required parameter 'adminConsoleSettings' is set
        if (adminConsoleSettings == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'adminConsoleSettings' when calling replaceFirstPartyAppSettings");
        }

        // create path and map variables
        String localVarPath = "/api/v1/first-party-app-settings/{appName}".replaceAll("\\{" + "appName" + "\\}",
                apiClient.escapeString(appName.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AdminConsoleSettings> localVarReturnType = new TypeReference<AdminConsoleSettings>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
