/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.CatalogApplication;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.Group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RoleBTargetClientApi {

    private ApiClient apiClient;

    public RoleBTargetClientApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleBTargetClientApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Assign a Client Role Application Instance Target Assigns an app instance target to an &#x60;APP_ADMIN&#x60; Role
     * Assignment to a client Application. When you assign the first OIN app or app instance target, you reduce the
     * scope of the Role Assignment. The Role no longer applies to all app targets, but applies only to the specified
     * target. &gt; **Note:** You can target a mixture of both OIN app and app instance targets, but you can&#39;t
     * assign permissions to manage all instances of an OIN app and then assign a subset of permissions to the same app.
     * For example, you can&#39;t specify that an admin has access to manage all instances of the Salesforce app and
     * then also manage only specific configurations of the Salesforce app.
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     * @param appId
     *            Application ID (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignAppTargetInstanceRoleForClient(String clientId, String roleAssignmentId, String appName,
            String appId) throws ApiException {
        this.assignAppTargetInstanceRoleForClient(clientId, roleAssignmentId, appName, appId, Collections.emptyMap());
    }

    /**
     * Assign a Client Role Application Instance Target Assigns an app instance target to an &#x60;APP_ADMIN&#x60; Role
     * Assignment to a client Application. When you assign the first OIN app or app instance target, you reduce the
     * scope of the Role Assignment. The Role no longer applies to all app targets, but applies only to the specified
     * target. &gt; **Note:** You can target a mixture of both OIN app and app instance targets, but you can&#39;t
     * assign permissions to manage all instances of an OIN app and then assign a subset of permissions to the same app.
     * For example, you can&#39;t specify that an admin has access to manage all instances of the Salesforce app and
     * then also manage only specific configurations of the Salesforce app.
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignAppTargetInstanceRoleForClient(String clientId, String roleAssignmentId, String appName,
            String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling assignAppTargetInstanceRoleForClient");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling assignAppTargetInstanceRoleForClient");
        }

        // verify the required parameter 'appName' is set
        if (appName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appName' when calling assignAppTargetInstanceRoleForClient");
        }

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling assignAppTargetInstanceRoleForClient");
        }

        // create path and map variables
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId}"
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()))
                .replaceAll("\\{" + "appName" + "\\}", apiClient.escapeString(appName.toString()))
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Assign a Client Role Application Target Assigns an OIN app target for an &#x60;APP_ADMIN&#x60; Role Assignment to
     * a client Application. When you assign an app target from the OIN catalog, you reduce the scope of the Role
     * Assignment. The Role applies to only app instances that are included in the specified OIN app target. An assigned
     * OIN app target overrides any existing app instance targets. For example, if a user is assigned to administer a
     * specific Facebook instance, a successful request to add an OIN app target with &#x60;facebook&#x60; for
     * &#x60;appName&#x60; makes that user the administrator for all Facebook instances.
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignAppTargetRoleToClient(String clientId, String roleAssignmentId, String appName)
            throws ApiException {
        this.assignAppTargetRoleToClient(clientId, roleAssignmentId, appName, Collections.emptyMap());
    }

    /**
     * Assign a Client Role Application Target Assigns an OIN app target for an &#x60;APP_ADMIN&#x60; Role Assignment to
     * a client Application. When you assign an app target from the OIN catalog, you reduce the scope of the Role
     * Assignment. The Role applies to only app instances that are included in the specified OIN app target. An assigned
     * OIN app target overrides any existing app instance targets. For example, if a user is assigned to administer a
     * specific Facebook instance, a successful request to add an OIN app target with &#x60;facebook&#x60; for
     * &#x60;appName&#x60; makes that user the administrator for all Facebook instances.
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignAppTargetRoleToClient(String clientId, String roleAssignmentId, String appName,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling assignAppTargetRoleToClient");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling assignAppTargetRoleToClient");
        }

        // verify the required parameter 'appName' is set
        if (appName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appName' when calling assignAppTargetRoleToClient");
        }

        // create path and map variables
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}"
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()))
                .replaceAll("\\{" + "appName" + "\\}", apiClient.escapeString(appName.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Assign a Client Role Group Target Assigns a Group target to a &#x60;USER_ADMIN&#x60;,
     * &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to a client Application. When
     * you assign the first Group target, you reduce the scope of the Role Assignment. The Role no longer applies to all
     * targets, but applies only to the specified target.
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignGroupTargetRoleForClient(String clientId, String roleAssignmentId, String groupId)
            throws ApiException {
        this.assignGroupTargetRoleForClient(clientId, roleAssignmentId, groupId, Collections.emptyMap());
    }

    /**
     * Assign a Client Role Group Target Assigns a Group target to a &#x60;USER_ADMIN&#x60;,
     * &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to a client Application. When
     * you assign the first Group target, you reduce the scope of the Role Assignment. The Role no longer applies to all
     * targets, but applies only to the specified target.
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignGroupTargetRoleForClient(String clientId, String roleAssignmentId, String groupId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling assignGroupTargetRoleForClient");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling assignGroupTargetRoleForClient");
        }

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'groupId' when calling assignGroupTargetRoleForClient");
        }

        // create path and map variables
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/groups/{groupId}"
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()))
                .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * List all Client Role Application Targets Lists all OIN app targets for an &#x60;APP_ADMIN&#x60; Role that&#39;s
     * assigned to a client Application (by &#x60;clientId&#x60;).
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     *
     * @return List&lt;CatalogApplication&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<CatalogApplication> listAppTargetRoleToClient(String clientId, String roleAssignmentId, String after,
            Integer limit) throws ApiException {
        return this.listAppTargetRoleToClient(clientId, roleAssignmentId, after, limit, Collections.emptyMap());
    }

    /**
     * List all Client Role Application Targets Lists all OIN app targets for an &#x60;APP_ADMIN&#x60; Role that&#39;s
     * assigned to a client Application (by &#x60;clientId&#x60;).
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;CatalogApplication&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<CatalogApplication> listAppTargetRoleToClient(String clientId, String roleAssignmentId, String after,
            Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling listAppTargetRoleToClient");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling listAppTargetRoleToClient");
        }

        // create path and map variables
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps"
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<CatalogApplication>> localVarReturnType = new TypeReference<List<CatalogApplication>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Client Role Group Targets Lists all Group targets for a &#x60;USER_ADMIN&#x60;,
     * &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to a client. If the Role
     * isn&#39;t scoped to specific Group targets, an empty array &#x60;[]&#x60; is returned.
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     *
     * @return List&lt;Group&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Group> listGroupTargetRoleForClient(String clientId, String roleAssignmentId, String after,
            Integer limit) throws ApiException {
        return this.listGroupTargetRoleForClient(clientId, roleAssignmentId, after, limit, Collections.emptyMap());
    }

    /**
     * List all Client Role Group Targets Lists all Group targets for a &#x60;USER_ADMIN&#x60;,
     * &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to a client. If the Role
     * isn&#39;t scoped to specific Group targets, an empty array &#x60;[]&#x60; is returned.
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;Group&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Group> listGroupTargetRoleForClient(String clientId, String roleAssignmentId, String after,
            Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling listGroupTargetRoleForClient");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling listGroupTargetRoleForClient");
        }

        // create path and map variables
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/groups"
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<Group>> localVarReturnType = new TypeReference<List<Group>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Unassign a Client Role Application Instance Target Unassigns an OIN app instance target from a Role Assignment to
     * a client Application &gt; **Note:** You can&#39;t remove the last app instance target from a Role Assignment
     * since this causes an exception. &gt; If you need a Role Assignment that applies to all the apps, delete the Role
     * Assignment and recreate a new one. See [Unassign a Client
     * Role](/openapi/okta-management/management/tag/RoleAssignmentClient/#tag/RoleAssignmentClient/operation/deleteRoleFromClient).
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     * @param appId
     *            Application ID (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void removeAppTargetInstanceRoleForClient(String clientId, String roleAssignmentId, String appName,
            String appId) throws ApiException {
        this.removeAppTargetInstanceRoleForClient(clientId, roleAssignmentId, appName, appId, Collections.emptyMap());
    }

    /**
     * Unassign a Client Role Application Instance Target Unassigns an OIN app instance target from a Role Assignment to
     * a client Application &gt; **Note:** You can&#39;t remove the last app instance target from a Role Assignment
     * since this causes an exception. &gt; If you need a Role Assignment that applies to all the apps, delete the Role
     * Assignment and recreate a new one. See [Unassign a Client
     * Role](/openapi/okta-management/management/tag/RoleAssignmentClient/#tag/RoleAssignmentClient/operation/deleteRoleFromClient).
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void removeAppTargetInstanceRoleForClient(String clientId, String roleAssignmentId, String appName,
            String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling removeAppTargetInstanceRoleForClient");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling removeAppTargetInstanceRoleForClient");
        }

        // verify the required parameter 'appName' is set
        if (appName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appName' when calling removeAppTargetInstanceRoleForClient");
        }

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling removeAppTargetInstanceRoleForClient");
        }

        // create path and map variables
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId}"
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()))
                .replaceAll("\\{" + "appName" + "\\}", apiClient.escapeString(appName.toString()))
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Unassign a Client Role Application Target Unassigns an OIN app target for a Role Assignment to a client
     * Application &gt; **Note:** You can&#39;t remove the last OIN app target from a Role Assignment since operation
     * causes an exception. &gt; If you need a Role assignment that applies to all apps, delete the Role Assignment and
     * recreate a new one. See [Unassign a Client
     * Role](/openapi/okta-management/management/tag/RoleAssignmentClient/#tag/RoleAssignmentClient/operation/deleteRoleFromClient).
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void removeAppTargetRoleFromClient(String clientId, String roleAssignmentId, String appName)
            throws ApiException {
        this.removeAppTargetRoleFromClient(clientId, roleAssignmentId, appName, Collections.emptyMap());
    }

    /**
     * Unassign a Client Role Application Target Unassigns an OIN app target for a Role Assignment to a client
     * Application &gt; **Note:** You can&#39;t remove the last OIN app target from a Role Assignment since operation
     * causes an exception. &gt; If you need a Role assignment that applies to all apps, delete the Role Assignment and
     * recreate a new one. See [Unassign a Client
     * Role](/openapi/okta-management/management/tag/RoleAssignmentClient/#tag/RoleAssignmentClient/operation/deleteRoleFromClient).
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void removeAppTargetRoleFromClient(String clientId, String roleAssignmentId, String appName,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling removeAppTargetRoleFromClient");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling removeAppTargetRoleFromClient");
        }

        // verify the required parameter 'appName' is set
        if (appName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appName' when calling removeAppTargetRoleFromClient");
        }

        // create path and map variables
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}"
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()))
                .replaceAll("\\{" + "appName" + "\\}", apiClient.escapeString(appName.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Unassign a Client Role Group Target Unassigns a Group target from a &#x60;USER_ADMIN&#x60;,
     * &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to a client Application. &gt;
     * **Note:** You can&#39;t remove the last Group target from a Role Assignment, as it causes an exception. If you
     * need a Role Assignment that applies to all Groups, delete the Role Assignment and recreate a new one. See
     * [Unassign a Client
     * Role](/openapi/okta-management/management/tag/RoleAssignmentClient/#tag/RoleAssignmentClient/operation/deleteRoleFromClient).
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void removeGroupTargetRoleFromClient(String clientId, String roleAssignmentId, String groupId)
            throws ApiException {
        this.removeGroupTargetRoleFromClient(clientId, roleAssignmentId, groupId, Collections.emptyMap());
    }

    /**
     * Unassign a Client Role Group Target Unassigns a Group target from a &#x60;USER_ADMIN&#x60;,
     * &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to a client Application. &gt;
     * **Note:** You can&#39;t remove the last Group target from a Role Assignment, as it causes an exception. If you
     * need a Role Assignment that applies to all Groups, delete the Role Assignment and recreate a new one. See
     * [Unassign a Client
     * Role](/openapi/okta-management/management/tag/RoleAssignmentClient/#tag/RoleAssignmentClient/operation/deleteRoleFromClient).
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void removeGroupTargetRoleFromClient(String clientId, String roleAssignmentId, String groupId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling removeGroupTargetRoleFromClient");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling removeGroupTargetRoleFromClient");
        }

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'groupId' when calling removeGroupTargetRoleFromClient");
        }

        // create path and map variables
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}/targets/groups/{groupId}"
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()))
                .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
