/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.CreateSessionRequest;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.Session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SessionApi {

    private ApiClient apiClient;

    public SessionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SessionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Close the current Session Closes the Session for the user who is currently signed in. Use this method in a
     * browser-based application to sign out a user. &gt; **Note:** This operation requires a session cookie for the
     * user. An API token isn&#39;t allowed for this operation.
     *
     * @param cookie
     *            (optional)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void closeCurrentSession(String cookie) throws ApiException {
        this.closeCurrentSession(cookie, Collections.emptyMap());
    }

    /**
     * Close the current Session Closes the Session for the user who is currently signed in. Use this method in a
     * browser-based application to sign out a user. &gt; **Note:** This operation requires a session cookie for the
     * user. An API token isn&#39;t allowed for this operation.
     *
     * @param cookie
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void closeCurrentSession(String cookie, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/sessions/me";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (cookie != null)
            localVarHeaderParams.put("Cookie", apiClient.parameterToString(cookie));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {};

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Create a Session with session token Creates a new Session for a user with a valid session token. Use this API if,
     * for example, you want to set the session cookie yourself instead of allowing Okta to set it, or want to hold the
     * session ID to delete a session through the API instead of visiting the logout URL.
     *
     * @param createSessionRequest
     *            (required)
     *
     * @return Session
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Session createSession(CreateSessionRequest createSessionRequest) throws ApiException {
        return this.createSession(createSessionRequest, Collections.emptyMap());
    }

    /**
     * Create a Session with session token Creates a new Session for a user with a valid session token. Use this API if,
     * for example, you want to set the session cookie yourself instead of allowing Okta to set it, or want to hold the
     * session ID to delete a session through the API instead of visiting the logout URL.
     *
     * @param createSessionRequest
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Session
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Session createSession(CreateSessionRequest createSessionRequest, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = createSessionRequest;

        // verify the required parameter 'createSessionRequest' is set
        if (createSessionRequest == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'createSessionRequest' when calling createSession");
        }

        // create path and map variables
        String localVarPath = "/api/v1/sessions";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken" };

        TypeReference<Session> localVarReturnType = new TypeReference<Session>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve the current Session Retrieves Session information for the current user. Use this method in a
     * browser-based application to determine if the user is signed in. &gt; **Note:** This operation requires a session
     * cookie for the user. An API token isn&#39;t allowed for this operation.
     *
     * @param cookie
     *            (optional)
     *
     * @return Session
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Session getCurrentSession(String cookie) throws ApiException {
        return this.getCurrentSession(cookie, Collections.emptyMap());
    }

    /**
     * Retrieve the current Session Retrieves Session information for the current user. Use this method in a
     * browser-based application to determine if the user is signed in. &gt; **Note:** This operation requires a session
     * cookie for the user. An API token isn&#39;t allowed for this operation.
     *
     * @param cookie
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Session
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Session getCurrentSession(String cookie, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/sessions/me";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (cookie != null)
            localVarHeaderParams.put("Cookie", apiClient.parameterToString(cookie));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {};

        TypeReference<Session> localVarReturnType = new TypeReference<Session>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a Session Retrieves information about the Session specified by the given session ID
     *
     * @param sessionId
     *            &#x60;id&#x60; of the Session (required)
     *
     * @return Session
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Session getSession(String sessionId) throws ApiException {
        return this.getSession(sessionId, Collections.emptyMap());
    }

    /**
     * Retrieve a Session Retrieves information about the Session specified by the given session ID
     *
     * @param sessionId
     *            &#x60;id&#x60; of the Session (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Session
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Session getSession(String sessionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'sessionId' is set
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling getSession");
        }

        // create path and map variables
        String localVarPath = "/api/v1/sessions/{sessionId}".replaceAll("\\{" + "sessionId" + "\\}",
                apiClient.escapeString(sessionId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Session> localVarReturnType = new TypeReference<Session>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Refresh the current Session Refreshes the Session for the current user &gt; **Note:** This operation requires a
     * session cookie for the user. An API token isn&#39;t allowed for this operation.
     *
     * @param cookie
     *            (optional)
     *
     * @return Session
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Session refreshCurrentSession(String cookie) throws ApiException {
        return this.refreshCurrentSession(cookie, Collections.emptyMap());
    }

    /**
     * Refresh the current Session Refreshes the Session for the current user &gt; **Note:** This operation requires a
     * session cookie for the user. An API token isn&#39;t allowed for this operation.
     *
     * @param cookie
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Session
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Session refreshCurrentSession(String cookie, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/sessions/me/lifecycle/refresh";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (cookie != null)
            localVarHeaderParams.put("Cookie", apiClient.parameterToString(cookie));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {};

        TypeReference<Session> localVarReturnType = new TypeReference<Session>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Refresh a Session Refreshes an existing Session using the &#x60;id&#x60; for that Session. A successful response
     * contains the refreshed Session with an updated &#x60;expiresAt&#x60; timestamp.
     *
     * @param sessionId
     *            &#x60;id&#x60; of the Session (required)
     *
     * @return Session
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Session refreshSession(String sessionId) throws ApiException {
        return this.refreshSession(sessionId, Collections.emptyMap());
    }

    /**
     * Refresh a Session Refreshes an existing Session using the &#x60;id&#x60; for that Session. A successful response
     * contains the refreshed Session with an updated &#x60;expiresAt&#x60; timestamp.
     *
     * @param sessionId
     *            &#x60;id&#x60; of the Session (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Session
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Session refreshSession(String sessionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'sessionId' is set
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling refreshSession");
        }

        // create path and map variables
        String localVarPath = "/api/v1/sessions/{sessionId}/lifecycle/refresh".replaceAll("\\{" + "sessionId" + "\\}",
                apiClient.escapeString(sessionId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Session> localVarReturnType = new TypeReference<Session>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Revoke a Session Revokes the specified Session
     *
     * @param sessionId
     *            &#x60;id&#x60; of the Session (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeSession(String sessionId) throws ApiException {
        this.revokeSession(sessionId, Collections.emptyMap());
    }

    /**
     * Revoke a Session Revokes the specified Session
     *
     * @param sessionId
     *            &#x60;id&#x60; of the Session (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeSession(String sessionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'sessionId' is set
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling revokeSession");
        }

        // create path and map variables
        String localVarPath = "/api/v1/sessions/{sessionId}".replaceAll("\\{" + "sessionId" + "\\}",
                apiClient.escapeString(sessionId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
