/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.SecurityEventsProviderRequest;
import com.okta.sdk.resource.model.SecurityEventsProviderResponse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SsfReceiverApi {

    private ApiClient apiClient;

    public SsfReceiverApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SsfReceiverApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate a Security Events Provider Activates a Security Events Provider instance by setting its status to
     * &#x60;ACTIVE&#x60;. This operation resumes the flow of events from the Security Events Provider to Okta.
     *
     * @param securityEventProviderId
     *            &#x60;id&#x60; of the Security Events Provider instance (required)
     *
     * @return SecurityEventsProviderResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SecurityEventsProviderResponse activateSecurityEventsProviderInstance(String securityEventProviderId)
            throws ApiException {
        return this.activateSecurityEventsProviderInstance(securityEventProviderId, Collections.emptyMap());
    }

    /**
     * Activate a Security Events Provider Activates a Security Events Provider instance by setting its status to
     * &#x60;ACTIVE&#x60;. This operation resumes the flow of events from the Security Events Provider to Okta.
     *
     * @param securityEventProviderId
     *            &#x60;id&#x60; of the Security Events Provider instance (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return SecurityEventsProviderResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SecurityEventsProviderResponse activateSecurityEventsProviderInstance(String securityEventProviderId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'securityEventProviderId' is set
        if (securityEventProviderId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'securityEventProviderId' when calling activateSecurityEventsProviderInstance");
        }

        // create path and map variables
        String localVarPath = "/api/v1/security-events-providers/{securityEventProviderId}/lifecycle/activate"
                .replaceAll("\\{" + "securityEventProviderId" + "\\}",
                        apiClient.escapeString(securityEventProviderId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<SecurityEventsProviderResponse> localVarReturnType = new TypeReference<SecurityEventsProviderResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a Security Events Provider Creates a Security Events Provider instance
     *
     * @param instance
     *            (required)
     *
     * @return SecurityEventsProviderResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SecurityEventsProviderResponse createSecurityEventsProviderInstance(SecurityEventsProviderRequest instance)
            throws ApiException {
        return this.createSecurityEventsProviderInstance(instance, Collections.emptyMap());
    }

    /**
     * Create a Security Events Provider Creates a Security Events Provider instance
     *
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return SecurityEventsProviderResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SecurityEventsProviderResponse createSecurityEventsProviderInstance(SecurityEventsProviderRequest instance,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'instance' when calling createSecurityEventsProviderInstance");
        }

        // create path and map variables
        String localVarPath = "/api/v1/security-events-providers";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<SecurityEventsProviderResponse> localVarReturnType = new TypeReference<SecurityEventsProviderResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate a Security Events Provider Deactivates a Security Events Provider instance by setting its status to
     * &#x60;INACTIVE&#x60;. This operation stops the flow of events from the Security Events Provider to Okta.
     *
     * @param securityEventProviderId
     *            &#x60;id&#x60; of the Security Events Provider instance (required)
     *
     * @return SecurityEventsProviderResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SecurityEventsProviderResponse deactivateSecurityEventsProviderInstance(String securityEventProviderId)
            throws ApiException {
        return this.deactivateSecurityEventsProviderInstance(securityEventProviderId, Collections.emptyMap());
    }

    /**
     * Deactivate a Security Events Provider Deactivates a Security Events Provider instance by setting its status to
     * &#x60;INACTIVE&#x60;. This operation stops the flow of events from the Security Events Provider to Okta.
     *
     * @param securityEventProviderId
     *            &#x60;id&#x60; of the Security Events Provider instance (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return SecurityEventsProviderResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SecurityEventsProviderResponse deactivateSecurityEventsProviderInstance(String securityEventProviderId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'securityEventProviderId' is set
        if (securityEventProviderId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'securityEventProviderId' when calling deactivateSecurityEventsProviderInstance");
        }

        // create path and map variables
        String localVarPath = "/api/v1/security-events-providers/{securityEventProviderId}/lifecycle/deactivate"
                .replaceAll("\\{" + "securityEventProviderId" + "\\}",
                        apiClient.escapeString(securityEventProviderId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<SecurityEventsProviderResponse> localVarReturnType = new TypeReference<SecurityEventsProviderResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Security Events Provider Deletes a Security Events Provider instance specified by &#x60;id&#x60;
     *
     * @param securityEventProviderId
     *            &#x60;id&#x60; of the Security Events Provider instance (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteSecurityEventsProviderInstance(String securityEventProviderId) throws ApiException {
        this.deleteSecurityEventsProviderInstance(securityEventProviderId, Collections.emptyMap());
    }

    /**
     * Delete a Security Events Provider Deletes a Security Events Provider instance specified by &#x60;id&#x60;
     *
     * @param securityEventProviderId
     *            &#x60;id&#x60; of the Security Events Provider instance (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteSecurityEventsProviderInstance(String securityEventProviderId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'securityEventProviderId' is set
        if (securityEventProviderId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'securityEventProviderId' when calling deleteSecurityEventsProviderInstance");
        }

        // create path and map variables
        String localVarPath = "/api/v1/security-events-providers/{securityEventProviderId}".replaceAll(
                "\\{" + "securityEventProviderId" + "\\}", apiClient.escapeString(securityEventProviderId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve the Security Events Provider Retrieves the Security Events Provider instance specified by &#x60;id&#x60;
     *
     * @param securityEventProviderId
     *            &#x60;id&#x60; of the Security Events Provider instance (required)
     *
     * @return SecurityEventsProviderResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SecurityEventsProviderResponse getSecurityEventsProviderInstance(String securityEventProviderId)
            throws ApiException {
        return this.getSecurityEventsProviderInstance(securityEventProviderId, Collections.emptyMap());
    }

    /**
     * Retrieve the Security Events Provider Retrieves the Security Events Provider instance specified by &#x60;id&#x60;
     *
     * @param securityEventProviderId
     *            &#x60;id&#x60; of the Security Events Provider instance (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return SecurityEventsProviderResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SecurityEventsProviderResponse getSecurityEventsProviderInstance(String securityEventProviderId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'securityEventProviderId' is set
        if (securityEventProviderId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'securityEventProviderId' when calling getSecurityEventsProviderInstance");
        }

        // create path and map variables
        String localVarPath = "/api/v1/security-events-providers/{securityEventProviderId}".replaceAll(
                "\\{" + "securityEventProviderId" + "\\}", apiClient.escapeString(securityEventProviderId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<SecurityEventsProviderResponse> localVarReturnType = new TypeReference<SecurityEventsProviderResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Security Events Providers Lists all Security Events Provider instances
     *
     * @return List&lt;SecurityEventsProviderResponse&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<SecurityEventsProviderResponse> listSecurityEventsProviderInstances() throws ApiException {
        return this.listSecurityEventsProviderInstances(Collections.emptyMap());
    }

    /**
     * List all Security Events Providers Lists all Security Events Provider instances
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;SecurityEventsProviderResponse&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<SecurityEventsProviderResponse> listSecurityEventsProviderInstances(
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/security-events-providers";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<SecurityEventsProviderResponse>> localVarReturnType = new TypeReference<List<SecurityEventsProviderResponse>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Security Events Provider Replaces a Security Events Provider instance specified by &#x60;id&#x60;
     *
     * @param securityEventProviderId
     *            &#x60;id&#x60; of the Security Events Provider instance (required)
     * @param instance
     *            (required)
     *
     * @return SecurityEventsProviderResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SecurityEventsProviderResponse replaceSecurityEventsProviderInstance(String securityEventProviderId,
            SecurityEventsProviderRequest instance) throws ApiException {
        return this.replaceSecurityEventsProviderInstance(securityEventProviderId, instance, Collections.emptyMap());
    }

    /**
     * Replace a Security Events Provider Replaces a Security Events Provider instance specified by &#x60;id&#x60;
     *
     * @param securityEventProviderId
     *            &#x60;id&#x60; of the Security Events Provider instance (required)
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return SecurityEventsProviderResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SecurityEventsProviderResponse replaceSecurityEventsProviderInstance(String securityEventProviderId,
            SecurityEventsProviderRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'securityEventProviderId' is set
        if (securityEventProviderId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'securityEventProviderId' when calling replaceSecurityEventsProviderInstance");
        }

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'instance' when calling replaceSecurityEventsProviderInstance");
        }

        // create path and map variables
        String localVarPath = "/api/v1/security-events-providers/{securityEventProviderId}".replaceAll(
                "\\{" + "securityEventProviderId" + "\\}", apiClient.escapeString(securityEventProviderId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<SecurityEventsProviderResponse> localVarReturnType = new TypeReference<SecurityEventsProviderResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
