package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * An array of ACS endpoints. You can configure a maximum of 100 endpoints.
 */
@ApiModel(description = "An array of ACS endpoints. You can configure a maximum of 100 endpoints.")
@JsonPropertyOrder({ AcsEndpoint.JSON_PROPERTY_INDEX, AcsEndpoint.JSON_PROPERTY_URL })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AcsEndpoint implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_INDEX = "index";
    private Integer index;

    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public AcsEndpoint() {
    }

    public AcsEndpoint index(Integer index) {

        this.index = index;
        return this;
    }

    /**
     * Index of the URL in the array of ACS endpoints
     *
     * @return index
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "0", required = true, value = "Index of the URL in the array of ACS endpoints")
    @JsonProperty(JSON_PROPERTY_INDEX)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public Integer getIndex() {
        return index;
    }

    @JsonProperty(JSON_PROPERTY_INDEX)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setIndex(Integer index) {
        this.index = index;
    }

    public AcsEndpoint url(String url) {

        this.url = url;
        return this;
    }

    /**
     * URL of the ACS
     *
     * @return url
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://www.example.com/sso/saml", required = true, value = "URL of the ACS")
    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getUrl() {
        return url;
    }

    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AcsEndpoint acsEndpoint = (AcsEndpoint) o;
        return Objects.equals(this.index, acsEndpoint.index) && Objects.equals(this.url, acsEndpoint.url);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(index, url);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AcsEndpoint {\n");
        sb.append("    index: ").append(toIndentedString(index)).append("\n");
        sb.append("    url: ").append(toIndentedString(url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
