package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.Agent;
import com.okta.sdk.resource.model.AgentType;
import com.okta.sdk.resource.model.OperationalStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * An AgentPool is a collection of agents that serve a common purpose. An AgentPool has a unique ID within an org, and
 * contains a collection of agents disjoint to every other AgentPool (i.e. no two AgentPools share an Agent).
 */
@ApiModel(description = "An AgentPool is a collection of agents that serve a common purpose. An AgentPool has a unique ID within an org, and contains a collection of agents disjoint to every other AgentPool (i.e. no two AgentPools share an Agent).")
@JsonPropertyOrder({ AgentPool.JSON_PROPERTY_AGENTS, AgentPool.JSON_PROPERTY_ID, AgentPool.JSON_PROPERTY_NAME,
        AgentPool.JSON_PROPERTY_OPERATIONAL_STATUS, AgentPool.JSON_PROPERTY_TYPE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AgentPool implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AGENTS = "agents";
    private List<Agent> agents = null;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_OPERATIONAL_STATUS = "operationalStatus";
    private OperationalStatus operationalStatus;

    public static final String JSON_PROPERTY_TYPE = "type";
    private AgentType type;

    public AgentPool() {
    }

    /*
     * @JsonCreator public AgentPool(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id ) { this(); this.id = id; }
     */

    public AgentPool agents(List<Agent> agents) {

        this.agents = agents;
        return this;
    }

    public AgentPool addagentsItem(Agent agentsItem) {
        if (this.agents == null) {
            this.agents = new ArrayList<>();
        }
        this.agents.add(agentsItem);
        return this;
    }

    /**
     * Get agents
     *
     * @return agents
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_AGENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<Agent> getAgents() {
        return agents;
    }

    @JsonProperty(JSON_PROPERTY_AGENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAgents(List<Agent> agents) {
        this.agents = agents;
    }

    /**
     * Get id
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public AgentPool name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Get name
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public AgentPool operationalStatus(OperationalStatus operationalStatus) {

        this.operationalStatus = operationalStatus;
        return this;
    }

    /**
     * Get operationalStatus
     *
     * @return operationalStatus
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OPERATIONAL_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OperationalStatus getOperationalStatus() {
        return operationalStatus;
    }

    @JsonProperty(JSON_PROPERTY_OPERATIONAL_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOperationalStatus(OperationalStatus operationalStatus) {
        this.operationalStatus = operationalStatus;
    }

    public AgentPool type(AgentType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AgentType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(AgentType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AgentPool agentPool = (AgentPool) o;
        return Objects.equals(this.agents, agentPool.agents) && Objects.equals(this.id, agentPool.id)
                && Objects.equals(this.name, agentPool.name)
                && Objects.equals(this.operationalStatus, agentPool.operationalStatus)
                && Objects.equals(this.type, agentPool.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(agents, id, name, operationalStatus, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentPool {\n");
        sb.append("    agents: ").append(toIndentedString(agents)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    operationalStatus: ").append(toIndentedString(operationalStatus)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
