package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The Network Condition of the API Token
 */
@ApiModel(description = "The Network Condition of the API Token")
@JsonPropertyOrder({ ApiTokenNetwork.JSON_PROPERTY_CONNECTION, ApiTokenNetwork.JSON_PROPERTY_INCLUDE,
        ApiTokenNetwork.JSON_PROPERTY_EXCLUDE })
@JsonTypeName("ApiToken_network")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ApiTokenNetwork implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONNECTION = "connection";
    private String connection;

    public static final String JSON_PROPERTY_INCLUDE = "include";
    private List<String> include = null;

    public static final String JSON_PROPERTY_EXCLUDE = "exclude";
    private List<String> exclude = null;

    public ApiTokenNetwork() {
    }

    public ApiTokenNetwork connection(String connection) {

        this.connection = connection;
        return this;
    }

    /**
     * The connection type of the Network Condition
     *
     * @return connection
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The connection type of the Network Condition")
    @JsonProperty(JSON_PROPERTY_CONNECTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getConnection() {
        return connection;
    }

    @JsonProperty(JSON_PROPERTY_CONNECTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConnection(String connection) {
        this.connection = connection;
    }

    public ApiTokenNetwork include(List<String> include) {

        this.include = include;
        return this;
    }

    public ApiTokenNetwork addincludeItem(String includeItem) {
        if (this.include == null) {
            this.include = new ArrayList<>();
        }
        this.include.add(includeItem);
        return this;
    }

    /**
     * List of included IP network zones
     *
     * @return include
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of included IP network zones")
    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getInclude() {
        return include;
    }

    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInclude(List<String> include) {
        this.include = include;
    }

    public ApiTokenNetwork exclude(List<String> exclude) {

        this.exclude = exclude;
        return this;
    }

    public ApiTokenNetwork addexcludeItem(String excludeItem) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<>();
        }
        this.exclude.add(excludeItem);
        return this;
    }

    /**
     * List of excluded IP network zones
     *
     * @return exclude
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of excluded IP network zones")
    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getExclude() {
        return exclude;
    }

    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExclude(List<String> exclude) {
        this.exclude = exclude;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApiTokenNetwork apiTokenNetwork = (ApiTokenNetwork) o;
        return Objects.equals(this.connection, apiTokenNetwork.connection)
                && Objects.equals(this.include, apiTokenNetwork.include)
                && Objects.equals(this.exclude, apiTokenNetwork.exclude);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(connection, include, exclude);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiTokenNetwork {\n");
        sb.append("    connection: ").append(toIndentedString(connection)).append("\n");
        sb.append("    include: ").append(toIndentedString(include)).append("\n");
        sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
