package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorKeyEnum;
import com.okta.sdk.resource.model.AuthenticatorLinks;
import com.okta.sdk.resource.model.AuthenticatorType;
import com.okta.sdk.resource.model.LifecycleStatus;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorBase
 */
@JsonPropertyOrder({ AuthenticatorBase.JSON_PROPERTY_CREATED, AuthenticatorBase.JSON_PROPERTY_ID,
        AuthenticatorBase.JSON_PROPERTY_KEY, AuthenticatorBase.JSON_PROPERTY_LAST_UPDATED,
        AuthenticatorBase.JSON_PROPERTY_NAME, AuthenticatorBase.JSON_PROPERTY_STATUS,
        AuthenticatorBase.JSON_PROPERTY_TYPE, AuthenticatorBase.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "key", visible = true, defaultImpl = AuthenticatorBase.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = AuthenticatorKeyCustomApp.class, name = "custom_app"),
        @JsonSubTypes.Type(value = AuthenticatorKeyDuo.class, name = "duo"),
        @JsonSubTypes.Type(value = AuthenticatorKeyExternalIdp.class, name = "external_idp"),
        @JsonSubTypes.Type(value = AuthenticatorKeyGoogleOtp.class, name = "google_otp"),
        @JsonSubTypes.Type(value = AuthenticatorKeyEmail.class, name = "okta_email"),
        @JsonSubTypes.Type(value = AuthenticatorKeyPassword.class, name = "okta_password"),
        @JsonSubTypes.Type(value = AuthenticatorKeyOktaVerify.class, name = "okta_verify"),
        @JsonSubTypes.Type(value = AuthenticatorKeyOnprem.class, name = "onprem_mfa"),
        @JsonSubTypes.Type(value = AuthenticatorKeyPhone.class, name = "phone_number"),
        @JsonSubTypes.Type(value = AuthenticatorKeySecurityKey.class, name = "security_key"),
        @JsonSubTypes.Type(value = AuthenticatorKeySecurityQuestion.class, name = "security_question"),
        @JsonSubTypes.Type(value = AuthenticatorKeySmartCard.class, name = "smart_card_idp"),
        @JsonSubTypes.Type(value = AuthenticatorKeySymantecVip.class, name = "symantec_vip"),
        @JsonSubTypes.Type(value = AuthenticatorKeyWebauthn.class, name = "webauthn"),
        @JsonSubTypes.Type(value = AuthenticatorKeyYubikey.class, name = "yubikey_token"),
        @JsonSubTypes.Type(value = AuthenticatorSimple.class, name = "AuthenticatorSimple"), })

public class AuthenticatorBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_KEY = "key";
    protected AuthenticatorKeyEnum key;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_STATUS = "status";
    private LifecycleStatus status;

    public static final String JSON_PROPERTY_TYPE = "type";
    private AuthenticatorType type;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private AuthenticatorLinks links;

    public AuthenticatorBase() {
    }

    /*
     * @JsonCreator public AuthenticatorBase(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; }
     */

    /**
     * Timestamp when the Authenticator was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Authenticator was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * A unique identifier for the Authenticator
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A unique identifier for the Authenticator")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public AuthenticatorBase key(AuthenticatorKeyEnum key) {

        this.key = key;
        return this;
    }

    /**
     * Get key
     *
     * @return key
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorKeyEnum getKey() {
        return key;
    }

    @JsonProperty(JSON_PROPERTY_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKey(AuthenticatorKeyEnum key) {
        this.key = key;
    }

    /**
     * Timestamp when the Authenticator was last modified
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Authenticator was last modified")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public AuthenticatorBase name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Display name of the Authenticator
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Display name of the Authenticator")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public AuthenticatorBase status(LifecycleStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(LifecycleStatus status) {
        this.status = status;
    }

    public AuthenticatorBase type(AuthenticatorType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(AuthenticatorType type) {
        this.type = type;
    }

    public AuthenticatorBase links(AuthenticatorLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(AuthenticatorLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorBase authenticatorBase = (AuthenticatorBase) o;
        return Objects.equals(this.created, authenticatorBase.created) && Objects.equals(this.id, authenticatorBase.id)
                && Objects.equals(this.key, authenticatorBase.key)
                && Objects.equals(this.lastUpdated, authenticatorBase.lastUpdated)
                && Objects.equals(this.name, authenticatorBase.name)
                && Objects.equals(this.status, authenticatorBase.status)
                && Objects.equals(this.type, authenticatorBase.type)
                && Objects.equals(this.links, authenticatorBase.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, id, key, lastUpdated, name, status, type, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorBase {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    key: ").append(toIndentedString(key)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
