package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AAGUIDGroupObject;
import com.okta.sdk.resource.model.UserVerificationEnum;
import com.okta.sdk.resource.model.WebAuthnAttachment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorMethodWebAuthnAllOfSettings
 */
@JsonPropertyOrder({ AuthenticatorMethodWebAuthnAllOfSettings.JSON_PROPERTY_AAGUID_GROUPS,
        AuthenticatorMethodWebAuthnAllOfSettings.JSON_PROPERTY_USER_VERIFICATION,
        AuthenticatorMethodWebAuthnAllOfSettings.JSON_PROPERTY_ATTACHMENT })
@JsonTypeName("AuthenticatorMethodWebAuthn_allOf_settings")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthenticatorMethodWebAuthnAllOfSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AAGUID_GROUPS = "aaguidGroups";
    private List<AAGUIDGroupObject> aaguidGroups = null;

    public static final String JSON_PROPERTY_USER_VERIFICATION = "userVerification";
    private UserVerificationEnum userVerification;

    public static final String JSON_PROPERTY_ATTACHMENT = "attachment";
    private WebAuthnAttachment attachment;

    public AuthenticatorMethodWebAuthnAllOfSettings() {
    }

    public AuthenticatorMethodWebAuthnAllOfSettings aaguidGroups(List<AAGUIDGroupObject> aaguidGroups) {

        this.aaguidGroups = aaguidGroups;
        return this;
    }

    public AuthenticatorMethodWebAuthnAllOfSettings addaaguidGroupsItem(AAGUIDGroupObject aaguidGroupsItem) {
        if (this.aaguidGroups == null) {
            this.aaguidGroups = new ArrayList<>();
        }
        this.aaguidGroups.add(aaguidGroupsItem);
        return this;
    }

    /**
     * &lt;x-lifecycle class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; The FIDO2 AAGUID groups available to the
     * WebAuthn authenticator
     *
     * @return aaguidGroups
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "<x-lifecycle class=\"ea\"></x-lifecycle> The FIDO2 AAGUID groups available to the WebAuthn authenticator")
    @JsonProperty(JSON_PROPERTY_AAGUID_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<AAGUIDGroupObject> getAaguidGroups() {
        return aaguidGroups;
    }

    @JsonProperty(JSON_PROPERTY_AAGUID_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAaguidGroups(List<AAGUIDGroupObject> aaguidGroups) {
        this.aaguidGroups = aaguidGroups;
    }

    public AuthenticatorMethodWebAuthnAllOfSettings userVerification(UserVerificationEnum userVerification) {

        this.userVerification = userVerification;
        return this;
    }

    /**
     * Get userVerification
     *
     * @return userVerification
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_VERIFICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserVerificationEnum getUserVerification() {
        return userVerification;
    }

    @JsonProperty(JSON_PROPERTY_USER_VERIFICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserVerification(UserVerificationEnum userVerification) {
        this.userVerification = userVerification;
    }

    public AuthenticatorMethodWebAuthnAllOfSettings attachment(WebAuthnAttachment attachment) {

        this.attachment = attachment;
        return this;
    }

    /**
     * Get attachment
     *
     * @return attachment
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ATTACHMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public WebAuthnAttachment getAttachment() {
        return attachment;
    }

    @JsonProperty(JSON_PROPERTY_ATTACHMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAttachment(WebAuthnAttachment attachment) {
        this.attachment = attachment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorMethodWebAuthnAllOfSettings authenticatorMethodWebAuthnAllOfSettings = (AuthenticatorMethodWebAuthnAllOfSettings) o;
        return Objects.equals(this.aaguidGroups, authenticatorMethodWebAuthnAllOfSettings.aaguidGroups)
                && Objects.equals(this.userVerification, authenticatorMethodWebAuthnAllOfSettings.userVerification)
                && Objects.equals(this.attachment, authenticatorMethodWebAuthnAllOfSettings.attachment);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(aaguidGroups, userVerification, attachment);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorMethodWebAuthnAllOfSettings {\n");
        sb.append("    aaguidGroups: ").append(toIndentedString(aaguidGroups)).append("\n");
        sb.append("    userVerification: ").append(toIndentedString(userVerification)).append("\n");
        sb.append("    attachment: ").append(toIndentedString(attachment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
