package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AutoLoginApplicationSettingsSignOn
 */
@JsonPropertyOrder({ AutoLoginApplicationSettingsSignOn.JSON_PROPERTY_LOGIN_URL,
        AutoLoginApplicationSettingsSignOn.JSON_PROPERTY_REDIRECT_URL })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AutoLoginApplicationSettingsSignOn implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_LOGIN_URL = "loginUrl";
    private String loginUrl;

    public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
    private String redirectUrl;

    public AutoLoginApplicationSettingsSignOn() {
    }

    public AutoLoginApplicationSettingsSignOn loginUrl(String loginUrl) {

        this.loginUrl = loginUrl;
        return this;
    }

    /**
     * Primary URL of the sign-in page for this app
     *
     * @return loginUrl
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Primary URL of the sign-in page for this app")
    @JsonProperty(JSON_PROPERTY_LOGIN_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getLoginUrl() {
        return loginUrl;
    }

    @JsonProperty(JSON_PROPERTY_LOGIN_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public AutoLoginApplicationSettingsSignOn redirectUrl(String redirectUrl) {

        this.redirectUrl = redirectUrl;
        return this;
    }

    /**
     * Secondary URL of the sign-in page for this app
     *
     * @return redirectUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Secondary URL of the sign-in page for this app")
    @JsonProperty(JSON_PROPERTY_REDIRECT_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRedirectUrl() {
        return redirectUrl;
    }

    @JsonProperty(JSON_PROPERTY_REDIRECT_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AutoLoginApplicationSettingsSignOn autoLoginApplicationSettingsSignOn = (AutoLoginApplicationSettingsSignOn) o;
        return Objects.equals(this.loginUrl, autoLoginApplicationSettingsSignOn.loginUrl)
                && Objects.equals(this.redirectUrl, autoLoginApplicationSettingsSignOn.redirectUrl);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(loginUrl, redirectUrl);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutoLoginApplicationSettingsSignOn {\n");
        sb.append("    loginUrl: ").append(toIndentedString(loginUrl)).append("\n");
        sb.append("    redirectUrl: ").append(toIndentedString(redirectUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
