package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefCsrPublishLink;
import com.okta.sdk.resource.model.HrefCsrSelfLink;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the current status
 * of a CSR object using the [JSON Hypertext Application
 * Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. This object is used for
 * dynamic discovery of related resources and lifecycle operations.
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the current status of a CSR object using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. This object is used for dynamic discovery of related resources and lifecycle operations.")
@JsonPropertyOrder({ CSRLinks.JSON_PROPERTY_PUBLISH, CSRLinks.JSON_PROPERTY_SELF })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class CSRLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PUBLISH = "publish";
    private HrefCsrPublishLink publish;

    public static final String JSON_PROPERTY_SELF = "self";
    private HrefCsrSelfLink self;

    public CSRLinks() {
    }

    public CSRLinks publish(HrefCsrPublishLink publish) {

        this.publish = publish;
        return this;
    }

    /**
     * Get publish
     *
     * @return publish
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PUBLISH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefCsrPublishLink getPublish() {
        return publish;
    }

    @JsonProperty(JSON_PROPERTY_PUBLISH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPublish(HrefCsrPublishLink publish) {
        this.publish = publish;
    }

    public CSRLinks self(HrefCsrSelfLink self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefCsrSelfLink getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefCsrSelfLink self) {
        this.self = self;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CSRLinks csRLinks = (CSRLinks) o;
        return Objects.equals(this.publish, csRLinks.publish) && Objects.equals(this.self, csRLinks.self);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(publish, self);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CSRLinks {\n");
        sb.append("    publish: ").append(toIndentedString(publish)).append("\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
