package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonAdmin;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonUser;
import com.okta.sdk.resource.model.SecurityEventSubject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The session of the subject was revoked
 */
@ApiModel(description = "The session of the subject was revoked")
@JsonPropertyOrder({ CaepSessionRevokedEvent.JSON_PROPERTY_CURRENT_IP,
        CaepSessionRevokedEvent.JSON_PROPERTY_CURRENT_USER_AGENT, CaepSessionRevokedEvent.JSON_PROPERTY_EVENT_TIMESTAMP,
        CaepSessionRevokedEvent.JSON_PROPERTY_INITIATING_ENTITY, CaepSessionRevokedEvent.JSON_PROPERTY_LAST_KNOWN_IP,
        CaepSessionRevokedEvent.JSON_PROPERTY_LAST_KNOWN_USER_AGENT, CaepSessionRevokedEvent.JSON_PROPERTY_REASON_ADMIN,
        CaepSessionRevokedEvent.JSON_PROPERTY_REASON_USER, CaepSessionRevokedEvent.JSON_PROPERTY_SUBJECT })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class CaepSessionRevokedEvent implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CURRENT_IP = "current_ip";
    private String currentIp;

    public static final String JSON_PROPERTY_CURRENT_USER_AGENT = "current_user_agent";
    private String currentUserAgent;

    public static final String JSON_PROPERTY_EVENT_TIMESTAMP = "event_timestamp";
    private Long eventTimestamp;

    /**
     * The entity that initiated the event
     */
    public enum InitiatingEntityEnum {
        ADMIN("admin"),

        USER("user"),

        POLICY("policy"),

        SYSTEM("system"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        InitiatingEntityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static InitiatingEntityEnum fromValue(String value) {
            for (InitiatingEntityEnum b : InitiatingEntityEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_INITIATING_ENTITY = "initiating_entity";
    private InitiatingEntityEnum initiatingEntity;

    public static final String JSON_PROPERTY_LAST_KNOWN_IP = "last_known_ip";
    private String lastKnownIp;

    public static final String JSON_PROPERTY_LAST_KNOWN_USER_AGENT = "last_known_user_agent";
    private String lastKnownUserAgent;

    public static final String JSON_PROPERTY_REASON_ADMIN = "reason_admin";
    private CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin;

    public static final String JSON_PROPERTY_REASON_USER = "reason_user";
    private CaepDeviceComplianceChangeEventReasonUser reasonUser;

    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private SecurityEventSubject subject;

    public CaepSessionRevokedEvent() {
    }

    public CaepSessionRevokedEvent currentIp(String currentIp) {

        this.currentIp = currentIp;
        return this;
    }

    /**
     * Current IP of the session
     *
     * @return currentIp
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "123.4.5.6", value = "Current IP of the session")
    @JsonProperty(JSON_PROPERTY_CURRENT_IP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCurrentIp() {
        return currentIp;
    }

    @JsonProperty(JSON_PROPERTY_CURRENT_IP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCurrentIp(String currentIp) {
        this.currentIp = currentIp;
    }

    public CaepSessionRevokedEvent currentUserAgent(String currentUserAgent) {

        this.currentUserAgent = currentUserAgent;
        return this;
    }

    /**
     * Current User Agent of the session
     *
     * @return currentUserAgent
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "CurrentUserAgent", value = "Current User Agent of the session")
    @JsonProperty(JSON_PROPERTY_CURRENT_USER_AGENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCurrentUserAgent() {
        return currentUserAgent;
    }

    @JsonProperty(JSON_PROPERTY_CURRENT_USER_AGENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCurrentUserAgent(String currentUserAgent) {
        this.currentUserAgent = currentUserAgent;
    }

    public CaepSessionRevokedEvent eventTimestamp(Long eventTimestamp) {

        this.eventTimestamp = eventTimestamp;
        return this;
    }

    /**
     * The time of the event (UNIX timestamp)
     *
     * @return eventTimestamp
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "1702448550", required = true, value = "The time of the event (UNIX timestamp)")
    @JsonProperty(JSON_PROPERTY_EVENT_TIMESTAMP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public Long getEventTimestamp() {
        return eventTimestamp;
    }

    @JsonProperty(JSON_PROPERTY_EVENT_TIMESTAMP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public CaepSessionRevokedEvent initiatingEntity(InitiatingEntityEnum initiatingEntity) {

        this.initiatingEntity = initiatingEntity;
        return this;
    }

    /**
     * The entity that initiated the event
     *
     * @return initiatingEntity
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The entity that initiated the event")
    @JsonProperty(JSON_PROPERTY_INITIATING_ENTITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public InitiatingEntityEnum getInitiatingEntity() {
        return initiatingEntity;
    }

    @JsonProperty(JSON_PROPERTY_INITIATING_ENTITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInitiatingEntity(InitiatingEntityEnum initiatingEntity) {
        this.initiatingEntity = initiatingEntity;
    }

    public CaepSessionRevokedEvent lastKnownIp(String lastKnownIp) {

        this.lastKnownIp = lastKnownIp;
        return this;
    }

    /**
     * Last known IP of the session
     *
     * @return lastKnownIp
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "123.4.5.6", value = "Last known IP of the session")
    @JsonProperty(JSON_PROPERTY_LAST_KNOWN_IP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastKnownIp() {
        return lastKnownIp;
    }

    @JsonProperty(JSON_PROPERTY_LAST_KNOWN_IP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLastKnownIp(String lastKnownIp) {
        this.lastKnownIp = lastKnownIp;
    }

    public CaepSessionRevokedEvent lastKnownUserAgent(String lastKnownUserAgent) {

        this.lastKnownUserAgent = lastKnownUserAgent;
        return this;
    }

    /**
     * Last known User Agent of the session
     *
     * @return lastKnownUserAgent
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "LastUserAgent", value = "Last known User Agent of the session")
    @JsonProperty(JSON_PROPERTY_LAST_KNOWN_USER_AGENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastKnownUserAgent() {
        return lastKnownUserAgent;
    }

    @JsonProperty(JSON_PROPERTY_LAST_KNOWN_USER_AGENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLastKnownUserAgent(String lastKnownUserAgent) {
        this.lastKnownUserAgent = lastKnownUserAgent;
    }

    public CaepSessionRevokedEvent reasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {

        this.reasonAdmin = reasonAdmin;
        return this;
    }

    /**
     * Get reasonAdmin
     *
     * @return reasonAdmin
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REASON_ADMIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CaepDeviceComplianceChangeEventReasonAdmin getReasonAdmin() {
        return reasonAdmin;
    }

    @JsonProperty(JSON_PROPERTY_REASON_ADMIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {
        this.reasonAdmin = reasonAdmin;
    }

    public CaepSessionRevokedEvent reasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {

        this.reasonUser = reasonUser;
        return this;
    }

    /**
     * Get reasonUser
     *
     * @return reasonUser
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REASON_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CaepDeviceComplianceChangeEventReasonUser getReasonUser() {
        return reasonUser;
    }

    @JsonProperty(JSON_PROPERTY_REASON_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {
        this.reasonUser = reasonUser;
    }

    public CaepSessionRevokedEvent subject(SecurityEventSubject subject) {

        this.subject = subject;
        return this;
    }

    /**
     * Get subject
     *
     * @return subject
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public SecurityEventSubject getSubject() {
        return subject;
    }

    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSubject(SecurityEventSubject subject) {
        this.subject = subject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CaepSessionRevokedEvent caepSessionRevokedEvent = (CaepSessionRevokedEvent) o;
        return Objects.equals(this.currentIp, caepSessionRevokedEvent.currentIp)
                && Objects.equals(this.currentUserAgent, caepSessionRevokedEvent.currentUserAgent)
                && Objects.equals(this.eventTimestamp, caepSessionRevokedEvent.eventTimestamp)
                && Objects.equals(this.initiatingEntity, caepSessionRevokedEvent.initiatingEntity)
                && Objects.equals(this.lastKnownIp, caepSessionRevokedEvent.lastKnownIp)
                && Objects.equals(this.lastKnownUserAgent, caepSessionRevokedEvent.lastKnownUserAgent)
                && Objects.equals(this.reasonAdmin, caepSessionRevokedEvent.reasonAdmin)
                && Objects.equals(this.reasonUser, caepSessionRevokedEvent.reasonUser)
                && Objects.equals(this.subject, caepSessionRevokedEvent.subject);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(currentIp, currentUserAgent, eventTimestamp, initiatingEntity, lastKnownIp,
                lastKnownUserAgent, reasonAdmin, reasonUser, subject);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaepSessionRevokedEvent {\n");
        sb.append("    currentIp: ").append(toIndentedString(currentIp)).append("\n");
        sb.append("    currentUserAgent: ").append(toIndentedString(currentUserAgent)).append("\n");
        sb.append("    eventTimestamp: ").append(toIndentedString(eventTimestamp)).append("\n");
        sb.append("    initiatingEntity: ").append(toIndentedString(initiatingEntity)).append("\n");
        sb.append("    lastKnownIp: ").append(toIndentedString(lastKnownIp)).append("\n");
        sb.append("    lastKnownUserAgent: ").append(toIndentedString(lastKnownUserAgent)).append("\n");
        sb.append("    reasonAdmin: ").append(toIndentedString(reasonAdmin)).append("\n");
        sb.append("    reasonUser: ").append(toIndentedString(reasonUser)).append("\n");
        sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
