package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.DNSRecordType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * DNS TXT and CNAME records to be registered for the Domain
 */
@ApiModel(description = "DNS TXT and CNAME records to be registered for the Domain")
@JsonPropertyOrder({ DNSRecord.JSON_PROPERTY_EXPIRATION, DNSRecord.JSON_PROPERTY_FQDN,
        DNSRecord.JSON_PROPERTY_RECORD_TYPE, DNSRecord.JSON_PROPERTY_VALUES })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class DNSRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXPIRATION = "expiration";
    private String expiration;

    public static final String JSON_PROPERTY_FQDN = "fqdn";
    private String fqdn;

    public static final String JSON_PROPERTY_RECORD_TYPE = "recordType";
    private DNSRecordType recordType;

    public static final String JSON_PROPERTY_VALUES = "values";
    private List<String> values = null;

    public DNSRecord() {
    }

    public DNSRecord expiration(String expiration) {

        this.expiration = expiration;
        return this;
    }

    /**
     * DNS TXT record expiration
     *
     * @return expiration
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "DNS TXT record expiration")
    @JsonProperty(JSON_PROPERTY_EXPIRATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getExpiration() {
        return expiration;
    }

    @JsonProperty(JSON_PROPERTY_EXPIRATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public DNSRecord fqdn(String fqdn) {

        this.fqdn = fqdn;
        return this;
    }

    /**
     * DNS record name
     *
     * @return fqdn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "_oktaverification.login.example.com", value = "DNS record name")
    @JsonProperty(JSON_PROPERTY_FQDN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getFqdn() {
        return fqdn;
    }

    @JsonProperty(JSON_PROPERTY_FQDN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFqdn(String fqdn) {
        this.fqdn = fqdn;
    }

    public DNSRecord recordType(DNSRecordType recordType) {

        this.recordType = recordType;
        return this;
    }

    /**
     * Get recordType
     *
     * @return recordType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RECORD_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DNSRecordType getRecordType() {
        return recordType;
    }

    @JsonProperty(JSON_PROPERTY_RECORD_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRecordType(DNSRecordType recordType) {
        this.recordType = recordType;
    }

    public DNSRecord values(List<String> values) {

        this.values = values;
        return this;
    }

    public DNSRecord addvaluesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<>();
        }
        this.values.add(valuesItem);
        return this;
    }

    /**
     * DNS record value
     *
     * @return values
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "[\"79496f234c814638b1cc44f51a782781\"]", value = "DNS record value")
    @JsonProperty(JSON_PROPERTY_VALUES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getValues() {
        return values;
    }

    @JsonProperty(JSON_PROPERTY_VALUES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValues(List<String> values) {
        this.values = values;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DNSRecord dnSRecord = (DNSRecord) o;
        return Objects.equals(this.expiration, dnSRecord.expiration) && Objects.equals(this.fqdn, dnSRecord.fqdn)
                && Objects.equals(this.recordType, dnSRecord.recordType)
                && Objects.equals(this.values, dnSRecord.values);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(expiration, fqdn, recordType, values);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DNSRecord {\n");
        sb.append("    expiration: ").append(toIndentedString(expiration)).append("\n");
        sb.append("    fqdn: ").append(toIndentedString(fqdn)).append("\n");
        sb.append("    recordType: ").append(toIndentedString(recordType)).append("\n");
        sb.append("    values: ").append(toIndentedString(values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
