package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.DeviceChecksPlatform;
import com.okta.sdk.resource.model.LinksSelf;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * DeviceCheck
 */
@JsonPropertyOrder({ DeviceCheck.JSON_PROPERTY_CREATED_BY, DeviceCheck.JSON_PROPERTY_CREATED_DATE,
        DeviceCheck.JSON_PROPERTY_DESCRIPTION, DeviceCheck.JSON_PROPERTY_ID, DeviceCheck.JSON_PROPERTY_LAST_UPDATE,
        DeviceCheck.JSON_PROPERTY_LAST_UPDATED_BY, DeviceCheck.JSON_PROPERTY_NAME, DeviceCheck.JSON_PROPERTY_PLATFORM,
        DeviceCheck.JSON_PROPERTY_QUERY, DeviceCheck.JSON_PROPERTY_VARIABLE_NAME, DeviceCheck.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class DeviceCheck implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private String createdBy;

    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private String createdDate;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private String lastUpdate;

    public static final String JSON_PROPERTY_LAST_UPDATED_BY = "lastUpdatedBy";
    private String lastUpdatedBy;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_PLATFORM = "platform";
    private DeviceChecksPlatform platform;

    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;

    public static final String JSON_PROPERTY_VARIABLE_NAME = "variableName";
    private String variableName;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public DeviceCheck() {
    }

    /*
     * @JsonCreator public DeviceCheck(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED_BY) String createdBy,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED_DATE) String createdDate,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATE) String lastUpdate,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY) String lastUpdatedBy ) { this(); this.createdBy = createdBy;
     * this.createdDate = createdDate; this.id = id; this.lastUpdate = lastUpdate; this.lastUpdatedBy = lastUpdatedBy; }
     */

    /**
     * User who created the Device Check
     *
     * @return createdBy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "00u217pyf72CdUrBt1c5", value = "User who created the Device Check")
    @JsonProperty(JSON_PROPERTY_CREATED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreatedBy() {
        return createdBy;
    }

    /**
     * Time the Device Check was created
     *
     * @return createdDate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2019-10-02T18:03:07.000Z", value = "Time the Device Check was created")
    @JsonProperty(JSON_PROPERTY_CREATED_DATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreatedDate() {
        return createdDate;
    }

    public DeviceCheck description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the Device Check
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Query macOS devices to check if firewall is enabled", value = "Description of the Device Check")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The ID of the Device Check
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "dch3m8o4rWhwReDeM1c5", value = "The ID of the Device Check")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Time the Device Check was updated
     *
     * @return lastUpdate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2019-10-02T18:03:07.000Z", value = "Time the Device Check was updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdate() {
        return lastUpdate;
    }

    /**
     * User who updated the Device Check
     *
     * @return lastUpdatedBy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "00u217pyf72CdUrBt1c5", value = "User who updated the Device Check")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdatedBy() {
        return lastUpdatedBy;
    }

    public DeviceCheck name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Display name of the Device Check
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Device Check macOS", value = "Display name of the Device Check")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public DeviceCheck platform(DeviceChecksPlatform platform) {

        this.platform = platform;
        return this;
    }

    /**
     * Get platform
     *
     * @return platform
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PLATFORM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DeviceChecksPlatform getPlatform() {
        return platform;
    }

    @JsonProperty(JSON_PROPERTY_PLATFORM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPlatform(DeviceChecksPlatform platform) {
        this.platform = platform;
    }

    public DeviceCheck query(String query) {

        this.query = query;
        return this;
    }

    /**
     * OSQuery for the Device Check
     *
     * @return query
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "SELECT CASE WHEN global_state = 0 THEN 0 ELSE 1 END AS firewall_enabled FROM  alf;", value = "OSQuery for the Device Check")
    @JsonProperty(JSON_PROPERTY_QUERY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getQuery() {
        return query;
    }

    @JsonProperty(JSON_PROPERTY_QUERY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setQuery(String query) {
        this.query = query;
    }

    public DeviceCheck variableName(String variableName) {

        this.variableName = variableName;
        return this;
    }

    /**
     * Unique name of the Device Check
     *
     * @return variableName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "macOSFirewall", value = "Unique name of the Device Check")
    @JsonProperty(JSON_PROPERTY_VARIABLE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getVariableName() {
        return variableName;
    }

    @JsonProperty(JSON_PROPERTY_VARIABLE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public DeviceCheck links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeviceCheck deviceCheck = (DeviceCheck) o;
        return Objects.equals(this.createdBy, deviceCheck.createdBy)
                && Objects.equals(this.createdDate, deviceCheck.createdDate)
                && Objects.equals(this.description, deviceCheck.description) && Objects.equals(this.id, deviceCheck.id)
                && Objects.equals(this.lastUpdate, deviceCheck.lastUpdate)
                && Objects.equals(this.lastUpdatedBy, deviceCheck.lastUpdatedBy)
                && Objects.equals(this.name, deviceCheck.name) && Objects.equals(this.platform, deviceCheck.platform)
                && Objects.equals(this.query, deviceCheck.query)
                && Objects.equals(this.variableName, deviceCheck.variableName)
                && Objects.equals(this.links, deviceCheck.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(createdBy, createdDate, description, id, lastUpdate, lastUpdatedBy, name, platform, query,
                variableName, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceCheck {\n");
        sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
        sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
        sb.append("    lastUpdatedBy: ").append(toIndentedString(lastUpdatedBy)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
        sb.append("    query: ").append(toIndentedString(query)).append("\n");
        sb.append("    variableName: ").append(toIndentedString(variableName)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
