package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.User;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * DeviceUser
 */
@JsonPropertyOrder({ DeviceUser.JSON_PROPERTY_CREATED, DeviceUser.JSON_PROPERTY_MANAGEMENT_STATUS,
        DeviceUser.JSON_PROPERTY_SCREEN_LOCK_TYPE, DeviceUser.JSON_PROPERTY_USER })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class DeviceUser implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;

    /**
     * The management status of the device
     */
    public enum ManagementStatusEnum {
        MANAGED("MANAGED"),

        NOT_MANAGED("NOT_MANAGED"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        ManagementStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ManagementStatusEnum fromValue(String value) {
            for (ManagementStatusEnum b : ManagementStatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_MANAGEMENT_STATUS = "managementStatus";
    private ManagementStatusEnum managementStatus;

    /**
     * Screen lock type of the device
     */
    public enum ScreenLockTypeEnum {
        NONE("NONE"),

        PASSCODE("PASSCODE"),

        BIOMETRIC("BIOMETRIC"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        ScreenLockTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ScreenLockTypeEnum fromValue(String value) {
            for (ScreenLockTypeEnum b : ScreenLockTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_SCREEN_LOCK_TYPE = "screenLockType";
    private ScreenLockTypeEnum screenLockType;

    public static final String JSON_PROPERTY_USER = "user";
    private User user;

    public DeviceUser() {
    }

    public DeviceUser created(String created) {

        this.created = created;
        return this;
    }

    /**
     * Timestamp when device was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when device was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreated() {
        return created;
    }

    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCreated(String created) {
        this.created = created;
    }

    public DeviceUser managementStatus(ManagementStatusEnum managementStatus) {

        this.managementStatus = managementStatus;
        return this;
    }

    /**
     * The management status of the device
     *
     * @return managementStatus
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The management status of the device")
    @JsonProperty(JSON_PROPERTY_MANAGEMENT_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ManagementStatusEnum getManagementStatus() {
        return managementStatus;
    }

    @JsonProperty(JSON_PROPERTY_MANAGEMENT_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setManagementStatus(ManagementStatusEnum managementStatus) {
        this.managementStatus = managementStatus;
    }

    public DeviceUser screenLockType(ScreenLockTypeEnum screenLockType) {

        this.screenLockType = screenLockType;
        return this;
    }

    /**
     * Screen lock type of the device
     *
     * @return screenLockType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Screen lock type of the device")
    @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ScreenLockTypeEnum getScreenLockType() {
        return screenLockType;
    }

    @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScreenLockType(ScreenLockTypeEnum screenLockType) {
        this.screenLockType = screenLockType;
    }

    public DeviceUser user(User user) {

        this.user = user;
        return this;
    }

    /**
     * Get user
     *
     * @return user
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public User getUser() {
        return user;
    }

    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeviceUser deviceUser = (DeviceUser) o;
        return Objects.equals(this.created, deviceUser.created)
                && Objects.equals(this.managementStatus, deviceUser.managementStatus)
                && Objects.equals(this.screenLockType, deviceUser.screenLockType)
                && Objects.equals(this.user, deviceUser.user);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, managementStatus, screenLockType, user);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceUser {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    managementStatus: ").append(toIndentedString(managementStatus)).append("\n");
        sb.append("    screenLockType: ").append(toIndentedString(screenLockType)).append("\n");
        sb.append("    user: ").append(toIndentedString(user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
