package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EmailServerPost
 */
@JsonPropertyOrder({ EmailServerPost.JSON_PROPERTY_ALIAS, EmailServerPost.JSON_PROPERTY_ENABLED,
        EmailServerPost.JSON_PROPERTY_HOST, EmailServerPost.JSON_PROPERTY_PORT, EmailServerPost.JSON_PROPERTY_USERNAME,
        EmailServerPost.JSON_PROPERTY_PASSWORD })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class EmailServerPost implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALIAS = "alias";
    private String alias;

    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;

    public static final String JSON_PROPERTY_HOST = "host";
    private String host;

    public static final String JSON_PROPERTY_PORT = "port";
    private Integer port;

    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;

    public EmailServerPost() {
    }

    public EmailServerPost alias(String alias) {

        this.alias = alias;
        return this;
    }

    /**
     * Human-readable name for your SMTP server
     *
     * @return alias
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "CustomServer1", required = true, value = "Human-readable name for your SMTP server")
    @JsonProperty(JSON_PROPERTY_ALIAS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getAlias() {
        return alias;
    }

    @JsonProperty(JSON_PROPERTY_ALIAS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAlias(String alias) {
        this.alias = alias;
    }

    public EmailServerPost enabled(Boolean enabled) {

        this.enabled = enabled;
        return this;
    }

    /**
     * If &#x60;true&#x60;, routes all email traffic through your SMTP server
     *
     * @return enabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "If `true`, routes all email traffic through your SMTP server")
    @JsonProperty(JSON_PROPERTY_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getEnabled() {
        return enabled;
    }

    @JsonProperty(JSON_PROPERTY_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public EmailServerPost host(String host) {

        this.host = host;
        return this;
    }

    /**
     * Hostname or IP address of your SMTP server
     *
     * @return host
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "192.168.160.1", required = true, value = "Hostname or IP address of your SMTP server")
    @JsonProperty(JSON_PROPERTY_HOST)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getHost() {
        return host;
    }

    @JsonProperty(JSON_PROPERTY_HOST)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setHost(String host) {
        this.host = host;
    }

    public EmailServerPost port(Integer port) {

        this.port = port;
        return this;
    }

    /**
     * Port number of your SMTP server
     *
     * @return port
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "587", required = true, value = "Port number of your SMTP server")
    @JsonProperty(JSON_PROPERTY_PORT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public Integer getPort() {
        return port;
    }

    @JsonProperty(JSON_PROPERTY_PORT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setPort(Integer port) {
        this.port = port;
    }

    public EmailServerPost username(String username) {

        this.username = username;
        return this;
    }

    /**
     * Username used to access your SMTP server
     *
     * @return username
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "aUser", required = true, value = "Username used to access your SMTP server")
    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getUsername() {
        return username;
    }

    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUsername(String username) {
        this.username = username;
    }

    public EmailServerPost password(String password) {

        this.password = password;
        return this;
    }

    /**
     * Password used to access your SMTP server
     *
     * @return password
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Password used to access your SMTP server")
    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getPassword() {
        return password;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailServerPost emailServerPost = (EmailServerPost) o;
        return Objects.equals(this.alias, emailServerPost.alias)
                && Objects.equals(this.enabled, emailServerPost.enabled)
                && Objects.equals(this.host, emailServerPost.host) && Objects.equals(this.port, emailServerPost.port)
                && Objects.equals(this.username, emailServerPost.username)
                && Objects.equals(this.password, emailServerPost.password);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(alias, enabled, host, port, username, password);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailServerPost {\n");
        sb.append("    alias: ").append(toIndentedString(alias)).append("\n");
        sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
        sb.append("    host: ").append(toIndentedString(host)).append("\n");
        sb.append("    port: ").append(toIndentedString(port)).append("\n");
        sb.append("    username: ").append(toIndentedString(username)).append("\n");
        sb.append("    password: ").append(toIndentedString(password)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
