package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GroupSchemaDefinitions;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.UserSchemaProperties;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * GroupSchema
 */
@JsonPropertyOrder({ GroupSchema.JSON_PROPERTY_$_SCHEMA, GroupSchema.JSON_PROPERTY_CREATED,
        GroupSchema.JSON_PROPERTY_DEFINITIONS, GroupSchema.JSON_PROPERTY_DESCRIPTION, GroupSchema.JSON_PROPERTY_ID,
        GroupSchema.JSON_PROPERTY_LAST_UPDATED, GroupSchema.JSON_PROPERTY_NAME, GroupSchema.JSON_PROPERTY_PROPERTIES,
        GroupSchema.JSON_PROPERTY_TITLE, GroupSchema.JSON_PROPERTY_TYPE, GroupSchema.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class GroupSchema implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_$_SCHEMA = "$schema";
    private String $schema;

    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;

    public static final String JSON_PROPERTY_DEFINITIONS = "definitions";
    private GroupSchemaDefinitions definitions;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private UserSchemaProperties properties;

    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public GroupSchema() {
    }

    /*
     * @JsonCreator public GroupSchema(
     *
     * @JsonProperty(JSON_PROPERTY_$_SCHEMA) String $schema,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) String created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) String lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_NAME) String name,
     *
     * @JsonProperty(JSON_PROPERTY_TYPE) String type ) { this(); this.$schema = $schema; this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; this.name = name; this.type = type; }
     */

    /**
     * JSON Schema version identifier
     *
     * @return $schema
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "JSON Schema version identifier")
    @JsonProperty(JSON_PROPERTY_$_SCHEMA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String get$Schema() {
        return $schema;
    }

    /**
     * Timestamp when the Schema was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Schema was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreated() {
        return created;
    }

    public GroupSchema definitions(GroupSchemaDefinitions definitions) {

        this.definitions = definitions;
        return this;
    }

    /**
     * Get definitions
     *
     * @return definitions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DEFINITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupSchemaDefinitions getDefinitions() {
        return definitions;
    }

    @JsonProperty(JSON_PROPERTY_DEFINITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDefinitions(GroupSchemaDefinitions definitions) {
        this.definitions = definitions;
    }

    public GroupSchema description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description for the Schema
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Description for the Schema")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * URI of Group Schema
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URI of Group Schema")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the Schema was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Schema was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdated() {
        return lastUpdated;
    }

    /**
     * Name of the Schema
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the Schema")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    public GroupSchema properties(UserSchemaProperties properties) {

        this.properties = properties;
        return this;
    }

    /**
     * Get properties
     *
     * @return properties
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROPERTIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaProperties getProperties() {
        return properties;
    }

    @JsonProperty(JSON_PROPERTY_PROPERTIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(UserSchemaProperties properties) {
        this.properties = properties;
    }

    public GroupSchema title(String title) {

        this.title = title;
        return this;
    }

    /**
     * User-defined display name for the Schema
     *
     * @return title
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "User-defined display name for the Schema")
    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTitle() {
        return title;
    }

    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * Type of [root Schema](https://tools.ietf.org/html/draft-zyp-json-schema-04#section-3.4)
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Type of [root Schema](https://tools.ietf.org/html/draft-zyp-json-schema-04#section-3.4)")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    public GroupSchema links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GroupSchema groupSchema = (GroupSchema) o;
        return Objects.equals(this.$schema, groupSchema.$schema) && Objects.equals(this.created, groupSchema.created)
                && Objects.equals(this.definitions, groupSchema.definitions)
                && Objects.equals(this.description, groupSchema.description) && Objects.equals(this.id, groupSchema.id)
                && Objects.equals(this.lastUpdated, groupSchema.lastUpdated)
                && Objects.equals(this.name, groupSchema.name)
                && Objects.equals(this.properties, groupSchema.properties)
                && Objects.equals(this.title, groupSchema.title) && Objects.equals(this.type, groupSchema.type)
                && Objects.equals(this.links, groupSchema.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash($schema, created, definitions, description, id, lastUpdated, name, properties, title, type,
                links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupSchema {\n");
        sb.append("    $schema: ").append(toIndentedString($schema)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    definitions: ").append(toIndentedString(definitions)).append("\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
        sb.append("    title: ").append(toIndentedString(title)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
