package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * A [JSON Web Key](https://tools.ietf.org/html/rfc7517) for a signature or encryption credential for an IdP
 */
@ApiModel(description = "A [JSON Web Key](https://tools.ietf.org/html/rfc7517) for a signature or encryption credential for an IdP")
@JsonPropertyOrder({ IdPKeyCredential.JSON_PROPERTY_CREATED, IdPKeyCredential.JSON_PROPERTY_E,
        IdPKeyCredential.JSON_PROPERTY_EXPIRES_AT, IdPKeyCredential.JSON_PROPERTY_KID,
        IdPKeyCredential.JSON_PROPERTY_KTY, IdPKeyCredential.JSON_PROPERTY_LAST_UPDATED,
        IdPKeyCredential.JSON_PROPERTY_N, IdPKeyCredential.JSON_PROPERTY_USE, IdPKeyCredential.JSON_PROPERTY_X5C,
        IdPKeyCredential.JSON_PROPERTY_X5T_HASH_S256 })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class IdPKeyCredential implements Serializable {

    private static final long serialVersionUID = 1L;

    public Map<String, Object> additionalProperties = new java.util.LinkedHashMap<>();

    public Map<String, Object> getAdditionalProperties() {
        return additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_E = "e";
    private String e;

    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;

    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;

    public static final String JSON_PROPERTY_KTY = "kty";
    private String kty;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_N = "n";
    private String n;

    public static final String JSON_PROPERTY_USE = "use";
    private String use;

    public static final String JSON_PROPERTY_X5C = "x5c";
    private List<String> x5c = null;

    public static final String JSON_PROPERTY_X5T_HASH_S256 = "x5t#S256";
    private String x5tHashS256;

    public IdPKeyCredential() {
    }

    /*
     * @JsonCreator public IdPKeyCredential(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_EXPIRES_AT) OffsetDateTime expiresAt,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created;
     * this.expiresAt = expiresAt; this.lastUpdated = lastUpdated; }
     */

    /**
     * Timestamp when the object was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2016-01-03T18:15:47Z", value = "Timestamp when the object was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    public IdPKeyCredential e(String e) {

        this.e = e;
        return this;
    }

    /**
     * The exponent value for the RSA public key
     *
     * @return e
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "AQAB", value = "The exponent value for the RSA public key")
    @JsonProperty(JSON_PROPERTY_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getE() {
        return e;
    }

    @JsonProperty(JSON_PROPERTY_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setE(String e) {
        this.e = e;
    }

    /**
     * Timestamp when the object expires
     *
     * @return expiresAt
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2016-01-03T18:15:47Z", value = "Timestamp when the object expires")
    @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getExpiresAt() {
        return expiresAt;
    }

    public IdPKeyCredential kid(String kid) {

        this.kid = kid;
        return this;
    }

    /**
     * Unique identifier for the key
     *
     * @return kid
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "your-key-id", value = "Unique identifier for the key")
    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKid() {
        return kid;
    }

    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public IdPKeyCredential kty(String kty) {

        this.kty = kty;
        return this;
    }

    /**
     * Identifies the cryptographic algorithm family used with the key (Supported value: &#x60;RSA&#x60;)
     *
     * @return kty
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "RSA", value = "Identifies the cryptographic algorithm family used with the key (Supported value: `RSA`)")
    @JsonProperty(JSON_PROPERTY_KTY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKty() {
        return kty;
    }

    @JsonProperty(JSON_PROPERTY_KTY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKty(String kty) {
        this.kty = kty;
    }

    /**
     * Timestamp when the object was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2016-01-03T18:15:47Z", value = "Timestamp when the object was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public IdPKeyCredential n(String n) {

        this.n = n;
        return this;
    }

    /**
     * The modulus value for the RSA public key
     *
     * @return n
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "101438407598598116085679865987760095721749307901605456708912786847324207000576780508113360584555007890315805735307890113536927352312915634368993759211767770602174860126854831344273970871509573365292777620005537635317282520456901584213746937262823585533063042033441296629204165064680610660631365266976782082747", value = "The modulus value for the RSA public key")
    @JsonProperty(JSON_PROPERTY_N)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getN() {
        return n;
    }

    @JsonProperty(JSON_PROPERTY_N)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setN(String n) {
        this.n = n;
    }

    public IdPKeyCredential use(String use) {

        this.use = use;
        return this;
    }

    /**
     * Intended use of the public key (Supported value: &#x60;sig&#x60;)
     *
     * @return use
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "sig", value = "Intended use of the public key (Supported value: `sig`)")
    @JsonProperty(JSON_PROPERTY_USE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUse() {
        return use;
    }

    @JsonProperty(JSON_PROPERTY_USE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUse(String use) {
        this.use = use;
    }

    public IdPKeyCredential x5c(List<String> x5c) {

        this.x5c = x5c;
        return this;
    }

    public IdPKeyCredential addx5cItem(String x5cItem) {
        if (this.x5c == null) {
            this.x5c = new ArrayList<>();
        }
        this.x5c.add(x5cItem);
        return this;
    }

    /**
     * Base64-encoded X.509 certificate chain with DER encoding
     *
     * @return x5c
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Base64-encoded X.509 certificate chain with DER encoding")
    @JsonProperty(JSON_PROPERTY_X5C)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getX5c() {
        return x5c;
    }

    @JsonProperty(JSON_PROPERTY_X5C)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setX5c(List<String> x5c) {
        this.x5c = x5c;
    }

    public IdPKeyCredential x5tHashS256(String x5tHashS256) {

        this.x5tHashS256 = x5tHashS256;
        return this;
    }

    /**
     * Base64url-encoded SHA-256 thumbprint of the DER encoding of an X.509 certificate
     *
     * @return x5tHashS256
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "wzPVobIrveR1x-PCbjsFGNV-6zn7Rm9KuOWOG4Rk6jE", value = "Base64url-encoded SHA-256 thumbprint of the DER encoding of an X.509 certificate")
    @JsonProperty(JSON_PROPERTY_X5T_HASH_S256)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getX5tHashS256() {
        return x5tHashS256;
    }

    @JsonProperty(JSON_PROPERTY_X5T_HASH_S256)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setX5tHashS256(String x5tHashS256) {
        this.x5tHashS256 = x5tHashS256;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdPKeyCredential idPKeyCredential = (IdPKeyCredential) o;
        return Objects.equals(this.created, idPKeyCredential.created) && Objects.equals(this.e, idPKeyCredential.e)
                && Objects.equals(this.expiresAt, idPKeyCredential.expiresAt)
                && Objects.equals(this.kid, idPKeyCredential.kid) && Objects.equals(this.kty, idPKeyCredential.kty)
                && Objects.equals(this.lastUpdated, idPKeyCredential.lastUpdated)
                && Objects.equals(this.n, idPKeyCredential.n) && Objects.equals(this.use, idPKeyCredential.use)
                && Objects.equals(this.x5c, idPKeyCredential.x5c)
                && Objects.equals(this.x5tHashS256, idPKeyCredential.x5tHashS256);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, e, expiresAt, kid, kty, lastUpdated, n, use, x5c, x5tHashS256, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdPKeyCredential {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    e: ").append(toIndentedString(e)).append("\n");
        sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
        sb.append("    kid: ").append(toIndentedString(kid)).append("\n");
        sb.append("    kty: ").append(toIndentedString(kty)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    n: ").append(toIndentedString(n)).append("\n");
        sb.append("    use: ").append(toIndentedString(use)).append("\n");
        sb.append("    x5c: ").append(toIndentedString(x5c)).append("\n");
        sb.append("    x5tHashS256: ").append(toIndentedString(x5tHashS256)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
