package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefObject;
import com.okta.sdk.resource.model.HrefObjectSelfLink;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * IdentityProviderApplicationUserLinks
 */
@JsonPropertyOrder({ IdentityProviderApplicationUserLinks.JSON_PROPERTY_SELF,
        IdentityProviderApplicationUserLinks.JSON_PROPERTY_NEXT, IdentityProviderApplicationUserLinks.JSON_PROPERTY_IDP,
        IdentityProviderApplicationUserLinks.JSON_PROPERTY_USER })
@JsonTypeName("IdentityProviderApplicationUser__links")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class IdentityProviderApplicationUserLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public Map<String, Object> additionalProperties = new java.util.LinkedHashMap<>();

    public Map<String, Object> getAdditionalProperties() {
        return additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public static final String JSON_PROPERTY_SELF = "self";
    private HrefObjectSelfLink self;

    public static final String JSON_PROPERTY_NEXT = "next";
    private HrefObject next;

    public static final String JSON_PROPERTY_IDP = "idp";
    private HrefObject idp;

    public static final String JSON_PROPERTY_USER = "user";
    private HrefObject user;

    public IdentityProviderApplicationUserLinks() {
    }

    public IdentityProviderApplicationUserLinks self(HrefObjectSelfLink self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectSelfLink getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefObjectSelfLink self) {
        this.self = self;
    }

    public IdentityProviderApplicationUserLinks next(HrefObject next) {

        this.next = next;
        return this;
    }

    /**
     * Get next
     *
     * @return next
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getNext() {
        return next;
    }

    @JsonProperty(JSON_PROPERTY_NEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNext(HrefObject next) {
        this.next = next;
    }

    public IdentityProviderApplicationUserLinks idp(HrefObject idp) {

        this.idp = idp;
        return this;
    }

    /**
     * The IdP instance
     *
     * @return idp
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The IdP instance")
    @JsonProperty(JSON_PROPERTY_IDP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getIdp() {
        return idp;
    }

    @JsonProperty(JSON_PROPERTY_IDP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIdp(HrefObject idp) {
        this.idp = idp;
    }

    public IdentityProviderApplicationUserLinks user(HrefObject user) {

        this.user = user;
        return this;
    }

    /**
     * The linked Okta User
     *
     * @return user
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The linked Okta User")
    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getUser() {
        return user;
    }

    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUser(HrefObject user) {
        this.user = user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdentityProviderApplicationUserLinks identityProviderApplicationUserLinks = (IdentityProviderApplicationUserLinks) o;
        return Objects.equals(this.self, identityProviderApplicationUserLinks.self)
                && Objects.equals(this.next, identityProviderApplicationUserLinks.next)
                && Objects.equals(this.idp, identityProviderApplicationUserLinks.idp)
                && Objects.equals(this.user, identityProviderApplicationUserLinks.user);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(self, next, idp, user, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityProviderApplicationUserLinks {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("    next: ").append(toIndentedString(next)).append("\n");
        sb.append("    idp: ").append(toIndentedString(idp)).append("\n");
        sb.append("    user: ").append(toIndentedString(user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
