package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticationMethodObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * KnowledgeConstraint
 */
@JsonPropertyOrder({ KnowledgeConstraint.JSON_PROPERTY_AUTHENTICATION_METHODS,
        KnowledgeConstraint.JSON_PROPERTY_EXCLUDED_AUTHENTICATION_METHODS, KnowledgeConstraint.JSON_PROPERTY_METHODS,
        KnowledgeConstraint.JSON_PROPERTY_REAUTHENTICATE_IN, KnowledgeConstraint.JSON_PROPERTY_REQUIRED,
        KnowledgeConstraint.JSON_PROPERTY_TYPES })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class KnowledgeConstraint implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTHENTICATION_METHODS = "authenticationMethods";
    private List<AuthenticationMethodObject> authenticationMethods = null;

    public static final String JSON_PROPERTY_EXCLUDED_AUTHENTICATION_METHODS = "excludedAuthenticationMethods";
    private List<AuthenticationMethodObject> excludedAuthenticationMethods = null;

    /**
     * Gets or Sets methods
     */
    public enum MethodsEnum {
        PASSWORD("PASSWORD"),

        SECURITY_QUESTION("SECURITY_QUESTION"),

        SMS("SMS"),

        VOICE("VOICE"),

        EMAIL("EMAIL"),

        PUSH("PUSH"),

        SIGNED_NONCE("SIGNED_NONCE"),

        OTP("OTP"),

        TOTP("TOTP"),

        WEBAUTHN("WEBAUTHN"),

        DUO("DUO"),

        IDP("IDP"),

        CERT("CERT"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        MethodsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static MethodsEnum fromValue(String value) {
            for (MethodsEnum b : MethodsEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_METHODS = "methods";
    private List<MethodsEnum> methods = null;

    public static final String JSON_PROPERTY_REAUTHENTICATE_IN = "reauthenticateIn";
    private String reauthenticateIn;

    public static final String JSON_PROPERTY_REQUIRED = "required";
    private Boolean required;

    /**
     * Gets or Sets types
     */
    public enum TypesEnum {
        SECURITY_KEY("SECURITY_KEY"),

        PHONE("PHONE"),

        EMAIL("EMAIL"),

        PASSWORD("PASSWORD"),

        SECURITY_QUESTION("SECURITY_QUESTION"),

        APP("APP"),

        FEDERATED("FEDERATED"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        TypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypesEnum fromValue(String value) {
            for (TypesEnum b : TypesEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPES = "types";
    private List<TypesEnum> types = null;

    public KnowledgeConstraint() {
    }

    public KnowledgeConstraint authenticationMethods(List<AuthenticationMethodObject> authenticationMethods) {

        this.authenticationMethods = authenticationMethods;
        return this;
    }

    public KnowledgeConstraint addauthenticationMethodsItem(AuthenticationMethodObject authenticationMethodsItem) {
        if (this.authenticationMethods == null) {
            this.authenticationMethods = new ArrayList<>();
        }
        this.authenticationMethods.add(authenticationMethodsItem);
        return this;
    }

    /**
     * This property specifies the precise authenticator and method for authentication. &lt;x-lifecycle
     * class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt;
     *
     * @return authenticationMethods
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "This property specifies the precise authenticator and method for authentication. <x-lifecycle class=\"oie\"></x-lifecycle>")
    @JsonProperty(JSON_PROPERTY_AUTHENTICATION_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<AuthenticationMethodObject> getAuthenticationMethods() {
        return authenticationMethods;
    }

    @JsonProperty(JSON_PROPERTY_AUTHENTICATION_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticationMethods(List<AuthenticationMethodObject> authenticationMethods) {
        this.authenticationMethods = authenticationMethods;
    }

    public KnowledgeConstraint excludedAuthenticationMethods(
            List<AuthenticationMethodObject> excludedAuthenticationMethods) {

        this.excludedAuthenticationMethods = excludedAuthenticationMethods;
        return this;
    }

    public KnowledgeConstraint addexcludedAuthenticationMethodsItem(
            AuthenticationMethodObject excludedAuthenticationMethodsItem) {
        if (this.excludedAuthenticationMethods == null) {
            this.excludedAuthenticationMethods = new ArrayList<>();
        }
        this.excludedAuthenticationMethods.add(excludedAuthenticationMethodsItem);
        return this;
    }

    /**
     * This property specifies the precise authenticator and method to exclude from authentication. &lt;x-lifecycle
     * class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt;
     *
     * @return excludedAuthenticationMethods
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "This property specifies the precise authenticator and method to exclude from authentication. <x-lifecycle class=\"oie\"></x-lifecycle>")
    @JsonProperty(JSON_PROPERTY_EXCLUDED_AUTHENTICATION_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<AuthenticationMethodObject> getExcludedAuthenticationMethods() {
        return excludedAuthenticationMethods;
    }

    @JsonProperty(JSON_PROPERTY_EXCLUDED_AUTHENTICATION_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExcludedAuthenticationMethods(List<AuthenticationMethodObject> excludedAuthenticationMethods) {
        this.excludedAuthenticationMethods = excludedAuthenticationMethods;
    }

    public KnowledgeConstraint methods(List<MethodsEnum> methods) {

        this.methods = methods;
        return this;
    }

    public KnowledgeConstraint addmethodsItem(MethodsEnum methodsItem) {
        if (this.methods == null) {
            this.methods = new ArrayList<>();
        }
        this.methods.add(methodsItem);
        return this;
    }

    /**
     * The Authenticator methods that are permitted
     *
     * @return methods
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Authenticator methods that are permitted")
    @JsonProperty(JSON_PROPERTY_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<MethodsEnum> getMethods() {
        return methods;
    }

    @JsonProperty(JSON_PROPERTY_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMethods(List<MethodsEnum> methods) {
        this.methods = methods;
    }

    public KnowledgeConstraint reauthenticateIn(String reauthenticateIn) {

        this.reauthenticateIn = reauthenticateIn;
        return this;
    }

    /**
     * The duration after which the user must re-authenticate regardless of user activity. This re-authentication
     * interval overrides the Verification Method object&#39;s &#x60;reauthenticateIn&#x60; interval. The supported
     * values use ISO 8601 period format for recurring time intervals (for example, &#x60;PT1H&#x60;).
     *
     * @return reauthenticateIn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The duration after which the user must re-authenticate regardless of user activity. This re-authentication interval overrides the Verification Method object's `reauthenticateIn` interval. The supported values use ISO 8601 period format for recurring time intervals (for example, `PT1H`).")
    @JsonProperty(JSON_PROPERTY_REAUTHENTICATE_IN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getReauthenticateIn() {
        return reauthenticateIn;
    }

    @JsonProperty(JSON_PROPERTY_REAUTHENTICATE_IN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReauthenticateIn(String reauthenticateIn) {
        this.reauthenticateIn = reauthenticateIn;
    }

    public KnowledgeConstraint required(Boolean required) {

        this.required = required;
        return this;
    }

    /**
     * This property indicates whether the knowledge or possession factor is required by the assurance. It&#39;s
     * optional in the request, but is always returned in the response. By default, this field is &#x60;true&#x60;. If
     * the knowledge or possession constraint has values for &#x60;excludedAuthenticationMethods&#x60; the
     * &#x60;required&#x60; value is false. &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt;
     *
     * @return required
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "This property indicates whether the knowledge or possession factor is required by the assurance. It's optional in the request, but is always returned in the response. By default, this field is `true`. If the knowledge or possession constraint has values for `excludedAuthenticationMethods` the `required` value is false. <x-lifecycle class=\"oie\"></x-lifecycle>")
    @JsonProperty(JSON_PROPERTY_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getRequired() {
        return required;
    }

    @JsonProperty(JSON_PROPERTY_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequired(Boolean required) {
        this.required = required;
    }

    public KnowledgeConstraint types(List<TypesEnum> types) {

        this.types = types;
        return this;
    }

    public KnowledgeConstraint addtypesItem(TypesEnum typesItem) {
        if (this.types == null) {
            this.types = new ArrayList<>();
        }
        this.types.add(typesItem);
        return this;
    }

    /**
     * The Authenticator types that are permitted
     *
     * @return types
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Authenticator types that are permitted")
    @JsonProperty(JSON_PROPERTY_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<TypesEnum> getTypes() {
        return types;
    }

    @JsonProperty(JSON_PROPERTY_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTypes(List<TypesEnum> types) {
        this.types = types;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        KnowledgeConstraint knowledgeConstraint = (KnowledgeConstraint) o;
        return Objects.equals(this.authenticationMethods, knowledgeConstraint.authenticationMethods)
                && Objects.equals(this.excludedAuthenticationMethods, knowledgeConstraint.excludedAuthenticationMethods)
                && Objects.equals(this.methods, knowledgeConstraint.methods)
                && Objects.equals(this.reauthenticateIn, knowledgeConstraint.reauthenticateIn)
                && Objects.equals(this.required, knowledgeConstraint.required)
                && Objects.equals(this.types, knowledgeConstraint.types);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authenticationMethods, excludedAuthenticationMethods, methods, reauthenticateIn, required,
                types);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeConstraint {\n");
        sb.append("    authenticationMethods: ").append(toIndentedString(authenticationMethods)).append("\n");
        sb.append("    excludedAuthenticationMethods: ").append(toIndentedString(excludedAuthenticationMethods))
                .append("\n");
        sb.append("    methods: ").append(toIndentedString(methods)).append("\n");
        sb.append("    reauthenticateIn: ").append(toIndentedString(reauthenticateIn)).append("\n");
        sb.append("    required: ").append(toIndentedString(required)).append("\n");
        sb.append("    types: ").append(toIndentedString(types)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
