package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LogGeographicalContext;
import com.okta.sdk.resource.model.LogUserAgent;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * When an event is triggered by an HTTP request, the &#x60;client&#x60; object describes the
 * [client](https://datatracker.ietf.org/doc/html/rfc2616) that issues the HTTP request. For instance, the web browser
 * is the client when a user accesses Okta. When this request is received and processed, a sign-in event is fired. When
 * the event isn&#39;t sourced to an HTTP request, such as an automatic update, the &#x60;client&#x60; object field is
 * blank.
 */
@ApiModel(description = "When an event is triggered by an HTTP request, the `client` object describes the [client](https://datatracker.ietf.org/doc/html/rfc2616) that issues the HTTP request. For instance, the web browser is the client when a user accesses Okta. When this request is received and processed, a sign-in event is fired. When the event isn't sourced to an HTTP request, such as an automatic update, the `client` object field is blank.")
@JsonPropertyOrder({ LogClient.JSON_PROPERTY_DEVICE, LogClient.JSON_PROPERTY_GEOGRAPHICAL_CONTEXT,
        LogClient.JSON_PROPERTY_ID, LogClient.JSON_PROPERTY_IP_ADDRESS, LogClient.JSON_PROPERTY_USER_AGENT,
        LogClient.JSON_PROPERTY_ZONE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class LogClient implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DEVICE = "device";
    private String device;

    public static final String JSON_PROPERTY_GEOGRAPHICAL_CONTEXT = "geographicalContext";
    private LogGeographicalContext geographicalContext;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
    private String ipAddress;

    public static final String JSON_PROPERTY_USER_AGENT = "userAgent";
    private LogUserAgent userAgent;

    public static final String JSON_PROPERTY_ZONE = "zone";
    private String zone;

    public LogClient() {
    }

    /*
     * @JsonCreator public LogClient(
     *
     * @JsonProperty(JSON_PROPERTY_DEVICE) String device,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_IP_ADDRESS) String ipAddress,
     *
     * @JsonProperty(JSON_PROPERTY_ZONE) String zone ) { this(); this.device = device; this.id = id; this.ipAddress =
     * ipAddress; this.zone = zone; }
     */

    /**
     * Type of device that the client operates from (for example, computer)
     *
     * @return device
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Type of device that the client operates from (for example, computer)")
    @JsonProperty(JSON_PROPERTY_DEVICE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDevice() {
        return device;
    }

    public LogClient geographicalContext(LogGeographicalContext geographicalContext) {

        this.geographicalContext = geographicalContext;
        return this;
    }

    /**
     * Get geographicalContext
     *
     * @return geographicalContext
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GEOGRAPHICAL_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LogGeographicalContext getGeographicalContext() {
        return geographicalContext;
    }

    @JsonProperty(JSON_PROPERTY_GEOGRAPHICAL_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGeographicalContext(LogGeographicalContext geographicalContext) {
        this.geographicalContext = geographicalContext;
    }

    /**
     * For OAuth requests, this is the ID of the OAuth
     * [client](https://datatracker.ietf.org/doc/html/rfc6749#section-1.1) making the request. For SSWS token requests,
     * this is the ID of the agent making the request.
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "For OAuth requests, this is the ID of the OAuth [client](https://datatracker.ietf.org/doc/html/rfc6749#section-1.1) making the request. For SSWS token requests, this is the ID of the agent making the request.")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * IP address that the client is making its request from
     *
     * @return ipAddress
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "IP address that the client is making its request from")
    @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIpAddress() {
        return ipAddress;
    }

    public LogClient userAgent(LogUserAgent userAgent) {

        this.userAgent = userAgent;
        return this;
    }

    /**
     * Get userAgent
     *
     * @return userAgent
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_AGENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LogUserAgent getUserAgent() {
        return userAgent;
    }

    @JsonProperty(JSON_PROPERTY_USER_AGENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserAgent(LogUserAgent userAgent) {
        this.userAgent = userAgent;
    }

    /**
     * The &#x60;name&#x60; of the
     * [Zone](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/NetworkZone/#tag/NetworkZone/operation/getNetworkZone)
     * that the client&#39;s location is mapped to
     *
     * @return zone
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `name` of the [Zone](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/NetworkZone/#tag/NetworkZone/operation/getNetworkZone) that the client's location is mapped to")
    @JsonProperty(JSON_PROPERTY_ZONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getZone() {
        return zone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogClient logClient = (LogClient) o;
        return Objects.equals(this.device, logClient.device)
                && Objects.equals(this.geographicalContext, logClient.geographicalContext)
                && Objects.equals(this.id, logClient.id) && Objects.equals(this.ipAddress, logClient.ipAddress)
                && Objects.equals(this.userAgent, logClient.userAgent) && Objects.equals(this.zone, logClient.zone);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(device, geographicalContext, id, ipAddress, userAgent, zone);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogClient {\n");
        sb.append("    device: ").append(toIndentedString(device)).append("\n");
        sb.append("    geographicalContext: ").append(toIndentedString(geographicalContext)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
        sb.append("    userAgent: ").append(toIndentedString(userAgent)).append("\n");
        sb.append("    zone: ").append(toIndentedString(zone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
