package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuth2RefreshTokenScopeLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OAuth2RefreshTokenScope
 */
@JsonPropertyOrder({ OAuth2RefreshTokenScope.JSON_PROPERTY_DESCRIPTION,
        OAuth2RefreshTokenScope.JSON_PROPERTY_DISPLAY_NAME, OAuth2RefreshTokenScope.JSON_PROPERTY_ID,
        OAuth2RefreshTokenScope.JSON_PROPERTY_NAME, OAuth2RefreshTokenScope.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OAuth2RefreshTokenScope implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private OAuth2RefreshTokenScopeLinks links;

    public OAuth2RefreshTokenScope() {
    }

    /*
     * @JsonCreator public OAuth2RefreshTokenScope(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id ) { this(); this.id = id; }
     */

    public OAuth2RefreshTokenScope description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the Scope
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Requests a refresh token by default, used to obtain more access tokens without re-prompting the user for authentication", value = "Description of the Scope")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public OAuth2RefreshTokenScope displayName(String displayName) {

        this.displayName = displayName;
        return this;
    }

    /**
     * Name of the end user displayed in a consent dialog
     *
     * @return displayName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the end user displayed in a consent dialog")
    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDisplayName() {
        return displayName;
    }

    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    /**
     * Scope object ID
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "scppb56cIl4GvGxy70g3", value = "Scope object ID")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public OAuth2RefreshTokenScope name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Scope name
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "offline_access", value = "Scope name")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OAuth2RefreshTokenScope links(OAuth2RefreshTokenScopeLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2RefreshTokenScopeLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OAuth2RefreshTokenScopeLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuth2RefreshTokenScope oauth2RefreshTokenScope = (OAuth2RefreshTokenScope) o;
        return Objects.equals(this.description, oauth2RefreshTokenScope.description)
                && Objects.equals(this.displayName, oauth2RefreshTokenScope.displayName)
                && Objects.equals(this.id, oauth2RefreshTokenScope.id)
                && Objects.equals(this.name, oauth2RefreshTokenScope.name)
                && Objects.equals(this.links, oauth2RefreshTokenScope.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, displayName, id, name, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2RefreshTokenScope {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
