package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AppResourceHrefObject;
import com.okta.sdk.resource.model.AuthorizationServerResourceHrefObject;
import com.okta.sdk.resource.model.HrefObjectSelfLink;
import com.okta.sdk.resource.model.ScopeResourceHrefObject;
import com.okta.sdk.resource.model.UserResourceHrefObject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OAuth2ScopeConsentGrantLinks
 */
@JsonPropertyOrder({ OAuth2ScopeConsentGrantLinks.JSON_PROPERTY_SELF, OAuth2ScopeConsentGrantLinks.JSON_PROPERTY_APP,
        OAuth2ScopeConsentGrantLinks.JSON_PROPERTY_CLIENT, OAuth2ScopeConsentGrantLinks.JSON_PROPERTY_SCOPE,
        OAuth2ScopeConsentGrantLinks.JSON_PROPERTY_USER,
        OAuth2ScopeConsentGrantLinks.JSON_PROPERTY_AUTHORIZATION_SERVER })
@JsonTypeName("OAuth2ScopeConsentGrant__links")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OAuth2ScopeConsentGrantLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SELF = "self";
    private HrefObjectSelfLink self;

    public static final String JSON_PROPERTY_APP = "app";
    private AppResourceHrefObject app;

    public static final String JSON_PROPERTY_CLIENT = "client";
    private AppResourceHrefObject client;

    public static final String JSON_PROPERTY_SCOPE = "scope";
    private ScopeResourceHrefObject scope;

    public static final String JSON_PROPERTY_USER = "user";
    private UserResourceHrefObject user;

    public static final String JSON_PROPERTY_AUTHORIZATION_SERVER = "authorizationServer";
    private AuthorizationServerResourceHrefObject authorizationServer;

    public OAuth2ScopeConsentGrantLinks() {
    }

    public OAuth2ScopeConsentGrantLinks self(HrefObjectSelfLink self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectSelfLink getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefObjectSelfLink self) {
        this.self = self;
    }

    public OAuth2ScopeConsentGrantLinks app(AppResourceHrefObject app) {

        this.app = app;
        return this;
    }

    /**
     * Link to the app resource
     *
     * @return app
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Link to the app resource")
    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppResourceHrefObject getApp() {
        return app;
    }

    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setApp(AppResourceHrefObject app) {
        this.app = app;
    }

    public OAuth2ScopeConsentGrantLinks client(AppResourceHrefObject client) {

        this.client = client;
        return this;
    }

    /**
     * Link to the client resource
     *
     * @return client
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Link to the client resource")
    @JsonProperty(JSON_PROPERTY_CLIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppResourceHrefObject getClient() {
        return client;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClient(AppResourceHrefObject client) {
        this.client = client;
    }

    public OAuth2ScopeConsentGrantLinks scope(ScopeResourceHrefObject scope) {

        this.scope = scope;
        return this;
    }

    /**
     * Link to the scope resource
     *
     * @return scope
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Link to the scope resource")
    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ScopeResourceHrefObject getScope() {
        return scope;
    }

    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScope(ScopeResourceHrefObject scope) {
        this.scope = scope;
    }

    public OAuth2ScopeConsentGrantLinks user(UserResourceHrefObject user) {

        this.user = user;
        return this;
    }

    /**
     * Link to the user resource
     *
     * @return user
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Link to the user resource")
    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserResourceHrefObject getUser() {
        return user;
    }

    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUser(UserResourceHrefObject user) {
        this.user = user;
    }

    public OAuth2ScopeConsentGrantLinks authorizationServer(AuthorizationServerResourceHrefObject authorizationServer) {

        this.authorizationServer = authorizationServer;
        return this;
    }

    /**
     * Link to the authorization server resource
     *
     * @return authorizationServer
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Link to the authorization server resource")
    @JsonProperty(JSON_PROPERTY_AUTHORIZATION_SERVER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthorizationServerResourceHrefObject getAuthorizationServer() {
        return authorizationServer;
    }

    @JsonProperty(JSON_PROPERTY_AUTHORIZATION_SERVER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizationServer(AuthorizationServerResourceHrefObject authorizationServer) {
        this.authorizationServer = authorizationServer;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuth2ScopeConsentGrantLinks oauth2ScopeConsentGrantLinks = (OAuth2ScopeConsentGrantLinks) o;
        return Objects.equals(this.self, oauth2ScopeConsentGrantLinks.self)
                && Objects.equals(this.app, oauth2ScopeConsentGrantLinks.app)
                && Objects.equals(this.client, oauth2ScopeConsentGrantLinks.client)
                && Objects.equals(this.scope, oauth2ScopeConsentGrantLinks.scope)
                && Objects.equals(this.user, oauth2ScopeConsentGrantLinks.user)
                && Objects.equals(this.authorizationServer, oauth2ScopeConsentGrantLinks.authorizationServer);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(self, app, client, scope, user, authorizationServer);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ScopeConsentGrantLinks {\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("    app: ").append(toIndentedString(app)).append("\n");
        sb.append("    client: ").append(toIndentedString(client)).append("\n");
        sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
        sb.append("    user: ").append(toIndentedString(user)).append("\n");
        sb.append("    authorizationServer: ").append(toIndentedString(authorizationServer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
