package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Group memberships used to determine link candidates
 */
@ApiModel(description = "Group memberships used to determine link candidates")
@JsonPropertyOrder({ PolicyAccountLinkFilterGroups.JSON_PROPERTY_INCLUDE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class PolicyAccountLinkFilterGroups implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_INCLUDE = "include";
    private List<String> include = null;

    public PolicyAccountLinkFilterGroups() {
    }

    public PolicyAccountLinkFilterGroups include(List<String> include) {

        this.include = include;
        return this;
    }

    public PolicyAccountLinkFilterGroups addincludeItem(String includeItem) {
        if (this.include == null) {
            this.include = new ArrayList<>();
        }
        this.include.add(includeItem);
        return this;
    }

    /**
     * Specifies the allowlist of Group identifiers to match against. Group memberships are restricted to type
     * &#x60;OKTA_GROUP&#x60;.
     *
     * @return include
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the allowlist of Group identifiers to match against. Group memberships are restricted to type `OKTA_GROUP`.")
    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getInclude() {
        return include;
    }

    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInclude(List<String> include) {
        this.include = include;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PolicyAccountLinkFilterGroups policyAccountLinkFilterGroups = (PolicyAccountLinkFilterGroups) o;
        return Objects.equals(this.include, policyAccountLinkFilterGroups.include);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(include);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyAccountLinkFilterGroups {\n");
        sb.append("    include: ").append(toIndentedString(include)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
