package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProvisioningConnectionOauthAuthScheme;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The app provisioning connection profile used to configure the method of authentication and the credentials.
 * Currently, token-based and OAuth 2.0-based authentication are supported.
 */
@ApiModel(description = "The app provisioning connection profile used to configure the method of authentication and the credentials. Currently, token-based and OAuth 2.0-based authentication are supported. ")
@JsonPropertyOrder({ ProvisioningConnectionProfileOauth.JSON_PROPERTY_AUTH_SCHEME,
        ProvisioningConnectionProfileOauth.JSON_PROPERTY_CLIENT_ID })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ProvisioningConnectionProfileOauth implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTH_SCHEME = "authScheme";
    private ProvisioningConnectionOauthAuthScheme authScheme;

    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId;

    public ProvisioningConnectionProfileOauth() {
    }

    public ProvisioningConnectionProfileOauth authScheme(ProvisioningConnectionOauthAuthScheme authScheme) {

        this.authScheme = authScheme;
        return this;
    }

    /**
     * Get authScheme
     *
     * @return authScheme
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_AUTH_SCHEME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public ProvisioningConnectionOauthAuthScheme getAuthScheme() {
        return authScheme;
    }

    @JsonProperty(JSON_PROPERTY_AUTH_SCHEME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAuthScheme(ProvisioningConnectionOauthAuthScheme authScheme) {
        this.authScheme = authScheme;
    }

    public ProvisioningConnectionProfileOauth clientId(String clientId) {

        this.clientId = clientId;
        return this;
    }

    /**
     * Get clientId
     *
     * @return clientId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CLIENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientId() {
        return clientId;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisioningConnectionProfileOauth provisioningConnectionProfileOauth = (ProvisioningConnectionProfileOauth) o;
        return Objects.equals(this.authScheme, provisioningConnectionProfileOauth.authScheme)
                && Objects.equals(this.clientId, provisioningConnectionProfileOauth.clientId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authScheme, clientId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProvisioningConnectionProfileOauth {\n");
        sb.append("    authScheme: ").append(toIndentedString(authScheme)).append("\n");
        sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
