package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.BaseContextUserLinks;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * RegistrationInlineHookPPDataAllOfDataContextUser
 */
@JsonPropertyOrder({ RegistrationInlineHookPPDataAllOfDataContextUser.JSON_PROPERTY_PASSWORD_CHANGED,
        RegistrationInlineHookPPDataAllOfDataContextUser.JSON_PROPERTY_LINKS,
        RegistrationInlineHookPPDataAllOfDataContextUser.JSON_PROPERTY_PROFILE,
        RegistrationInlineHookPPDataAllOfDataContextUser.JSON_PROPERTY_ID })
@JsonTypeName("RegistrationInlineHookPPData_allOf_data_context_user")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RegistrationInlineHookPPDataAllOfDataContextUser implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PASSWORD_CHANGED = "passwordChanged";
    private OffsetDateTime passwordChanged;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private BaseContextUserLinks links;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public RegistrationInlineHookPPDataAllOfDataContextUser() {
    }

    public RegistrationInlineHookPPDataAllOfDataContextUser passwordChanged(OffsetDateTime passwordChanged) {

        this.passwordChanged = passwordChanged;
        return this;
    }

    /**
     * The last time the user&#39;s password was updated
     *
     * @return passwordChanged
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The last time the user's password was updated")
    @JsonProperty(JSON_PROPERTY_PASSWORD_CHANGED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getPasswordChanged() {
        return passwordChanged;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD_CHANGED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPasswordChanged(OffsetDateTime passwordChanged) {
        this.passwordChanged = passwordChanged;
    }

    public RegistrationInlineHookPPDataAllOfDataContextUser links(BaseContextUserLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BaseContextUserLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(BaseContextUserLinks links) {
        this.links = links;
    }

    public RegistrationInlineHookPPDataAllOfDataContextUser profile(Map<String, Object> profile) {

        this.profile = profile;
        return this;
    }

    public RegistrationInlineHookPPDataAllOfDataContextUser putprofileItem(String key, Object profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    /**
     * The user to update&#39;s current attributes
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The user to update's current attributes")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public RegistrationInlineHookPPDataAllOfDataContextUser id(String id) {

        this.id = id;
        return this;
    }

    /**
     * Get id
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RegistrationInlineHookPPDataAllOfDataContextUser registrationInlineHookPPDataAllOfDataContextUser = (RegistrationInlineHookPPDataAllOfDataContextUser) o;
        return Objects.equals(this.passwordChanged, registrationInlineHookPPDataAllOfDataContextUser.passwordChanged)
                && Objects.equals(this.links, registrationInlineHookPPDataAllOfDataContextUser.links)
                && Objects.equals(this.profile, registrationInlineHookPPDataAllOfDataContextUser.profile)
                && Objects.equals(this.id, registrationInlineHookPPDataAllOfDataContextUser.id);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(passwordChanged, links, profile, id);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegistrationInlineHookPPDataAllOfDataContextUser {\n");
        sb.append("    passwordChanged: ").append(toIndentedString(passwordChanged)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
