package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.RegistrationResponseErrorErrorCausesInner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * For the registration inline hook, the &#x60;error&#x60; object provides a way of displaying an error message to the
 * end user who is trying to register or update their profile. * If you&#39;re using the Okta Sign-In Widget for Profile
 * Enrollment, only the &#x60;errorSummary&#x60; messages of the &#x60;errorCauses&#x60; objects that your external
 * service returns appear as inline errors, given the following: * You don&#39;t customize the error handling behavior
 * of the widget. * The &#x60;location&#x60; of &#x60;errorSummary&#x60; in the &#x60;errorCauses&#x60; object specifies
 * the request object&#39;s user profile attribute. * If you don&#39;t return a value for the &#x60;errorCauses&#x60;
 * object, and deny the user&#39;s registration attempt through the &#x60;commands&#x60; object in your response to
 * Okta, one of the following generic messages appears to the end user: * \&quot;Registration cannot be completed at
 * this time.\&quot; (SSR) * \&quot;We found some errors. Please review the form and make corrections.\&quot;
 * (Progressive Enrollment) * If you don&#39;t return an &#x60;error&#x60; object at all and the registration is denied,
 * the following generic message appears to the end user: * \&quot;Registration denied.\&quot; (SSR) * \&quot;Profile
 * update denied.\&quot; (Progressive Enrollment) &gt;**Note:** If you include an error object in your response, no
 * commands are executed and the registration fails. This holds true even if the top-level &#x60;errorSummary&#x60; and
 * the &#x60;errorCauses&#x60; objects are omitted.
 */
@ApiModel(description = "For the registration inline hook, the `error` object provides a way of displaying an error message to the end user who is trying to register or update their profile.  * If you're using the Okta Sign-In Widget for Profile Enrollment, only the `errorSummary` messages of the `errorCauses` objects that your external service returns appear as inline errors, given the following:   * You don't customize the error handling behavior of the widget.   * The `location` of `errorSummary` in the `errorCauses` object specifies the request object's user profile attribute. * If you don't return a value for the `errorCauses` object, and deny the user's registration attempt through the `commands` object in your response to Okta, one of the following generic messages appears to the end user:   * \"Registration cannot be completed at this time.\" (SSR)   * \"We found some errors. Please review the form and make corrections.\" (Progressive Enrollment) * If you don't return an `error` object at all and the registration is denied, the following generic message appears to the end user:   * \"Registration denied.\" (SSR)   * \"Profile update denied.\" (Progressive Enrollment)  >**Note:** If you include an error object in your response, no commands are executed and the registration fails. This holds true even if the top-level `errorSummary` and the `errorCauses` objects are omitted.")
@JsonPropertyOrder({ RegistrationResponseError.JSON_PROPERTY_ERROR_SUMMARY,
        RegistrationResponseError.JSON_PROPERTY_ERROR_CAUSES })
@JsonTypeName("RegistrationResponse_Error")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RegistrationResponseError implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ERROR_SUMMARY = "errorSummary";
    private String errorSummary;

    public static final String JSON_PROPERTY_ERROR_CAUSES = "errorCauses";
    private List<RegistrationResponseErrorErrorCausesInner> errorCauses = null;

    public RegistrationResponseError() {
    }

    public RegistrationResponseError errorSummary(String errorSummary) {

        this.errorSummary = errorSummary;
        return this;
    }

    /**
     * Human-readable summary of one or more errors
     *
     * @return errorSummary
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Human-readable summary of one or more errors")
    @JsonProperty(JSON_PROPERTY_ERROR_SUMMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getErrorSummary() {
        return errorSummary;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_SUMMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setErrorSummary(String errorSummary) {
        this.errorSummary = errorSummary;
    }

    public RegistrationResponseError errorCauses(List<RegistrationResponseErrorErrorCausesInner> errorCauses) {

        this.errorCauses = errorCauses;
        return this;
    }

    public RegistrationResponseError adderrorCausesItem(RegistrationResponseErrorErrorCausesInner errorCausesItem) {
        if (this.errorCauses == null) {
            this.errorCauses = new ArrayList<>();
        }
        this.errorCauses.add(errorCausesItem);
        return this;
    }

    /**
     * Get errorCauses
     *
     * @return errorCauses
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ERROR_CAUSES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<RegistrationResponseErrorErrorCausesInner> getErrorCauses() {
        return errorCauses;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_CAUSES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setErrorCauses(List<RegistrationResponseErrorErrorCausesInner> errorCauses) {
        this.errorCauses = errorCauses;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RegistrationResponseError registrationResponseError = (RegistrationResponseError) o;
        return Objects.equals(this.errorSummary, registrationResponseError.errorSummary)
                && Objects.equals(this.errorCauses, registrationResponseError.errorCauses);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(errorSummary, errorCauses);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegistrationResponseError {\n");
        sb.append("    errorSummary: ").append(toIndentedString(errorSummary)).append("\n");
        sb.append("    errorCauses: ").append(toIndentedString(errorCauses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
