package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ResourceSetResourceLinks;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ResourceSetResource
 */
@JsonPropertyOrder({ ResourceSetResource.JSON_PROPERTY_CREATED, ResourceSetResource.JSON_PROPERTY_ID,
        ResourceSetResource.JSON_PROPERTY_LAST_UPDATED, ResourceSetResource.JSON_PROPERTY_ORN,
        ResourceSetResource.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ResourceSetResource implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_ORN = "orn";
    private String orn;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private ResourceSetResourceLinks links;

    public ResourceSetResource() {
    }

    /*
     * @JsonCreator public ResourceSetResource(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; }
     */

    /**
     * Timestamp when the Resource Set Resource object was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Resource Set Resource object was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Unique ID of the Resource Set Resource object
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique ID of the Resource Set Resource object")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when this object was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when this object was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public ResourceSetResource orn(String orn) {

        this.orn = orn;
        return this;
    }

    /**
     * The Okta Resource Name (ORN) of the resource
     *
     * @return orn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Okta Resource Name (ORN) of the resource")
    @JsonProperty(JSON_PROPERTY_ORN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOrn() {
        return orn;
    }

    @JsonProperty(JSON_PROPERTY_ORN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOrn(String orn) {
        this.orn = orn;
    }

    public ResourceSetResource links(ResourceSetResourceLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ResourceSetResourceLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(ResourceSetResourceLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceSetResource resourceSetResource = (ResourceSetResource) o;
        return Objects.equals(this.created, resourceSetResource.created)
                && Objects.equals(this.id, resourceSetResource.id)
                && Objects.equals(this.lastUpdated, resourceSetResource.lastUpdated)
                && Objects.equals(this.orn, resourceSetResource.orn)
                && Objects.equals(this.links, resourceSetResource.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, id, lastUpdated, orn, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSetResource {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    orn: ").append(toIndentedString(orn)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
