package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Rotate password request for the privileged account
 */
@ApiModel(description = "Rotate password request for the privileged account")
@JsonPropertyOrder({ RotatePasswordRequest.JSON_PROPERTY_PASSWORD,
        RotatePasswordRequest.JSON_PROPERTY_SECRET_VERSION_ID })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RotatePasswordRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;

    public static final String JSON_PROPERTY_SECRET_VERSION_ID = "secretVersionId";
    private String secretVersionId;

    public RotatePasswordRequest() {
    }

    public RotatePasswordRequest password(String password) {

        this.password = password;
        return this;
    }

    /**
     * The password associated with the privileged resource
     *
     * @return password
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "xf1bs9am2", required = true, value = "The password associated with the privileged resource")
    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getPassword() {
        return password;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setPassword(String password) {
        this.password = password;
    }

    public RotatePasswordRequest secretVersionId(String secretVersionId) {

        this.secretVersionId = secretVersionId;
        return this;
    }

    /**
     * The version ID of the password secret from the OPA vault
     *
     * @return secretVersionId
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "9f8400-e29b-41d4-a716-926655440034", required = true, value = "The version ID of the password secret from the OPA vault")
    @JsonProperty(JSON_PROPERTY_SECRET_VERSION_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getSecretVersionId() {
        return secretVersionId;
    }

    @JsonProperty(JSON_PROPERTY_SECRET_VERSION_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSecretVersionId(String secretVersionId) {
        this.secretVersionId = secretVersionId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RotatePasswordRequest rotatePasswordRequest = (RotatePasswordRequest) o;
        return Objects.equals(this.password, rotatePasswordRequest.password)
                && Objects.equals(this.secretVersionId, rotatePasswordRequest.secretVersionId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(password, secretVersionId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RotatePasswordRequest {\n");
        sb.append("    password: ").append(toIndentedString(password)).append("\n");
        sb.append("    secretVersionId: ").append(toIndentedString(secretVersionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
