package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SAMLHookResponseCommandsInner;
import com.okta.sdk.resource.model.SAMLHookResponseError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SAMLHookResponse
 */
@JsonPropertyOrder({ SAMLHookResponse.JSON_PROPERTY_COMMANDS, SAMLHookResponse.JSON_PROPERTY_ERROR })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SAMLHookResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_COMMANDS = "commands";
    private List<SAMLHookResponseCommandsInner> commands = null;

    public static final String JSON_PROPERTY_ERROR = "error";
    private SAMLHookResponseError error;

    public SAMLHookResponse() {
    }

    public SAMLHookResponse commands(List<SAMLHookResponseCommandsInner> commands) {

        this.commands = commands;
        return this;
    }

    public SAMLHookResponse addcommandsItem(SAMLHookResponseCommandsInner commandsItem) {
        if (this.commands == null) {
            this.commands = new ArrayList<>();
        }
        this.commands.add(commandsItem);
        return this;
    }

    /**
     * The &#x60;commands&#x60; object is where you tell Okta to add additional claims to the assertion or to modify the
     * existing assertion statements. &#x60;commands&#x60; is an array, allowing you to send multiple commands. In each
     * array element, include a &#x60;type&#x60; property and a &#x60;value&#x60; property. The &#x60;type&#x60;
     * property is where you specify which of the supported commands you want to execute, and &#x60;value&#x60; is where
     * you supply an operand for that command. In the case of the SAML assertion inline hook, the &#x60;value&#x60;
     * property is itself a nested object, in which you specify a particular operation, a path to act on, and a value.
     *
     * @return commands
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `commands` object is where you tell Okta to add additional claims to the assertion or to modify the existing assertion statements.  `commands` is an array, allowing you to send multiple commands. In each array element, include a `type` property and a `value` property. The `type` property is where you specify which of the supported commands you want to execute, and `value` is where you supply an operand for that command. In the case of the SAML assertion inline hook, the `value` property is itself a nested object, in which you specify a particular operation, a path to act on, and a value. ")
    @JsonProperty(JSON_PROPERTY_COMMANDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<SAMLHookResponseCommandsInner> getCommands() {
        return commands;
    }

    @JsonProperty(JSON_PROPERTY_COMMANDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCommands(List<SAMLHookResponseCommandsInner> commands) {
        this.commands = commands;
    }

    public SAMLHookResponse error(SAMLHookResponseError error) {

        this.error = error;
        return this;
    }

    /**
     * Get error
     *
     * @return error
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SAMLHookResponseError getError() {
        return error;
    }

    @JsonProperty(JSON_PROPERTY_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setError(SAMLHookResponseError error) {
        this.error = error;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SAMLHookResponse saMLHookResponse = (SAMLHookResponse) o;
        return Objects.equals(this.commands, saMLHookResponse.commands)
                && Objects.equals(this.error, saMLHookResponse.error);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(commands, error);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLHookResponse {\n");
        sb.append("    commands: ").append(toIndentedString(commands)).append("\n");
        sb.append("    error: ").append(toIndentedString(error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
