package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertionAuthentication;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertionClaimsValue;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertionConditions;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertionLifetime;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertionSubject;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Details of the SAML assertion that was generated
 */
@ApiModel(description = "Details of the SAML assertion that was generated")
@JsonPropertyOrder({ SAMLPayLoadDataAssertion.JSON_PROPERTY_SUBJECT,
        SAMLPayLoadDataAssertion.JSON_PROPERTY_AUTHENTICATION, SAMLPayLoadDataAssertion.JSON_PROPERTY_CONDITIONS,
        SAMLPayLoadDataAssertion.JSON_PROPERTY_CLAIMS, SAMLPayLoadDataAssertion.JSON_PROPERTY_LIFETIME })
@JsonTypeName("SAMLPayLoad_data_assertion")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SAMLPayLoadDataAssertion implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private SAMLPayLoadDataAssertionSubject subject;

    public static final String JSON_PROPERTY_AUTHENTICATION = "authentication";
    private SAMLPayLoadDataAssertionAuthentication authentication;

    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private SAMLPayLoadDataAssertionConditions conditions;

    public static final String JSON_PROPERTY_CLAIMS = "claims";
    private Map<String, SAMLPayLoadDataAssertionClaimsValue> claims = null;

    public static final String JSON_PROPERTY_LIFETIME = "lifetime";
    private SAMLPayLoadDataAssertionLifetime lifetime;

    public SAMLPayLoadDataAssertion() {
    }

    public SAMLPayLoadDataAssertion subject(SAMLPayLoadDataAssertionSubject subject) {

        this.subject = subject;
        return this;
    }

    /**
     * Get subject
     *
     * @return subject
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SAMLPayLoadDataAssertionSubject getSubject() {
        return subject;
    }

    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(SAMLPayLoadDataAssertionSubject subject) {
        this.subject = subject;
    }

    public SAMLPayLoadDataAssertion authentication(SAMLPayLoadDataAssertionAuthentication authentication) {

        this.authentication = authentication;
        return this;
    }

    /**
     * Get authentication
     *
     * @return authentication
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_AUTHENTICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SAMLPayLoadDataAssertionAuthentication getAuthentication() {
        return authentication;
    }

    @JsonProperty(JSON_PROPERTY_AUTHENTICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthentication(SAMLPayLoadDataAssertionAuthentication authentication) {
        this.authentication = authentication;
    }

    public SAMLPayLoadDataAssertion conditions(SAMLPayLoadDataAssertionConditions conditions) {

        this.conditions = conditions;
        return this;
    }

    /**
     * Get conditions
     *
     * @return conditions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SAMLPayLoadDataAssertionConditions getConditions() {
        return conditions;
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(SAMLPayLoadDataAssertionConditions conditions) {
        this.conditions = conditions;
    }

    public SAMLPayLoadDataAssertion claims(Map<String, SAMLPayLoadDataAssertionClaimsValue> claims) {

        this.claims = claims;
        return this;
    }

    public SAMLPayLoadDataAssertion putclaimsItem(String key, SAMLPayLoadDataAssertionClaimsValue claimsItem) {
        if (this.claims == null) {
            this.claims = new HashMap<>();
        }
        this.claims.put(key, claimsItem);
        return this;
    }

    /**
     * Provides a JSON representation of the &#x60;&lt;saml:AttributeStatement&gt;&#x60; element contained in the
     * generated SAML assertion. Contains any optional SAML attribute statements that you have defined for the app using
     * the Admin Console&#39;s **SAML Settings**.
     *
     * @return claims
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Provides a JSON representation of the `<saml:AttributeStatement>` element contained in the generated SAML assertion. Contains any optional SAML attribute statements that you have defined for the app using the Admin Console's **SAML Settings**.")
    @JsonProperty(JSON_PROPERTY_CLAIMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, SAMLPayLoadDataAssertionClaimsValue> getClaims() {
        return claims;
    }

    @JsonProperty(JSON_PROPERTY_CLAIMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClaims(Map<String, SAMLPayLoadDataAssertionClaimsValue> claims) {
        this.claims = claims;
    }

    public SAMLPayLoadDataAssertion lifetime(SAMLPayLoadDataAssertionLifetime lifetime) {

        this.lifetime = lifetime;
        return this;
    }

    /**
     * Get lifetime
     *
     * @return lifetime
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LIFETIME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SAMLPayLoadDataAssertionLifetime getLifetime() {
        return lifetime;
    }

    @JsonProperty(JSON_PROPERTY_LIFETIME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLifetime(SAMLPayLoadDataAssertionLifetime lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SAMLPayLoadDataAssertion saMLPayLoadDataAssertion = (SAMLPayLoadDataAssertion) o;
        return Objects.equals(this.subject, saMLPayLoadDataAssertion.subject)
                && Objects.equals(this.authentication, saMLPayLoadDataAssertion.authentication)
                && Objects.equals(this.conditions, saMLPayLoadDataAssertion.conditions)
                && Objects.equals(this.claims, saMLPayLoadDataAssertion.claims)
                && Objects.equals(this.lifetime, saMLPayLoadDataAssertion.lifetime);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(subject, authentication, conditions, claims, lifetime);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLPayLoadDataAssertion {\n");
        sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
        sb.append("    authentication: ").append(toIndentedString(authentication)).append("\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("    claims: ").append(toIndentedString(claims)).append("\n");
        sb.append("    lifetime: ").append(toIndentedString(lifetime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
