package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies the expiration time, in seconds, of the SAML assertion
 */
@ApiModel(description = "Specifies the expiration time, in seconds, of the SAML assertion")
@JsonPropertyOrder({ SAMLPayLoadDataAssertionLifetime.JSON_PROPERTY_EXPIRATION })
@JsonTypeName("SAMLPayLoad_data_assertion_lifetime")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SAMLPayLoadDataAssertionLifetime implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXPIRATION = "expiration";
    private Integer expiration;

    public SAMLPayLoadDataAssertionLifetime() {
    }

    public SAMLPayLoadDataAssertionLifetime expiration(Integer expiration) {

        this.expiration = expiration;
        return this;
    }

    /**
     * The expiration time in seconds
     *
     * @return expiration
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "300", value = "The expiration time in seconds")
    @JsonProperty(JSON_PROPERTY_EXPIRATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getExpiration() {
        return expiration;
    }

    @JsonProperty(JSON_PROPERTY_EXPIRATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExpiration(Integer expiration) {
        this.expiration = expiration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SAMLPayLoadDataAssertionLifetime saMLPayLoadDataAssertionLifetime = (SAMLPayLoadDataAssertionLifetime) o;
        return Objects.equals(this.expiration, saMLPayLoadDataAssertionLifetime.expiration);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(expiration);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLPayLoadDataAssertionLifetime {\n");
        sb.append("    expiration: ").append(toIndentedString(expiration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
