package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SamlRequestSignatureAlgorithm;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Algorithm settings used to secure an &#x60;&lt;AuthnRequest&gt;&#x60; message
 */
@ApiModel(description = "Algorithm settings used to secure an `<AuthnRequest>` message")
@JsonPropertyOrder({ SamlRequestAlgorithm.JSON_PROPERTY_SIGNATURE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SamlRequestAlgorithm implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    private SamlRequestSignatureAlgorithm signature;

    public SamlRequestAlgorithm() {
    }

    public SamlRequestAlgorithm signature(SamlRequestSignatureAlgorithm signature) {

        this.signature = signature;
        return this;
    }

    /**
     * Get signature
     *
     * @return signature
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SIGNATURE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SamlRequestSignatureAlgorithm getSignature() {
        return signature;
    }

    @JsonProperty(JSON_PROPERTY_SIGNATURE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSignature(SamlRequestSignatureAlgorithm signature) {
        this.signature = signature;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlRequestAlgorithm samlRequestAlgorithm = (SamlRequestAlgorithm) o;
        return Objects.equals(this.signature, samlRequestAlgorithm.signature);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(signature);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlRequestAlgorithm {\n");
        sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
