package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ScopeResourceHrefObject
 */
@JsonPropertyOrder({ ScopeResourceHrefObject.JSON_PROPERTY_HREF, ScopeResourceHrefObject.JSON_PROPERTY_TITLE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ScopeResourceHrefObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_HREF = "href";
    private String href;

    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public ScopeResourceHrefObject() {
    }

    public ScopeResourceHrefObject href(String href) {

        this.href = href;
        return this;
    }

    /**
     * Link URI
     *
     * @return href
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://{yourOktaDomain}/api/v1/authorizationServers/ausain6z9zIedDCxB0h7/scopes/scpCmCCV1DpxVkCaye2X", value = "Link URI")
    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getHref() {
        return href;
    }

    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHref(String href) {
        this.href = href;
    }

    public ScopeResourceHrefObject title(String title) {

        this.title = title;
        return this;
    }

    /**
     * Link name
     *
     * @return title
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "My phone", value = "Link name")
    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTitle() {
        return title;
    }

    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ScopeResourceHrefObject scopeResourceHrefObject = (ScopeResourceHrefObject) o;
        return Objects.equals(this.href, scopeResourceHrefObject.href)
                && Objects.equals(this.title, scopeResourceHrefObject.title);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(href, title);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScopeResourceHrefObject {\n");
        sb.append("    href: ").append(toIndentedString(href)).append("\n");
        sb.append("    title: ").append(toIndentedString(title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
