package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Error object thrown when parsing the Security Event Token
 */
@ApiModel(description = "Error object thrown when parsing the Security Event Token")
@JsonPropertyOrder({ SecurityEventTokenError.JSON_PROPERTY_DESCRIPTION, SecurityEventTokenError.JSON_PROPERTY_ERR })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SecurityEventTokenError implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    /**
     * A code that describes the category of the error
     */
    public enum ErrEnum {
        AUTHENTICATION_FAILED("authentication_failed"),

        INVALID_AUDIENCE("invalid_audience"),

        INVALID_ISSUER("invalid_issuer"),

        INVALID_KEY("invalid_key"),

        INVALID_REQUEST("invalid_request"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        ErrEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ErrEnum fromValue(String value) {
            for (ErrEnum b : ErrEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_ERR = "err";
    private ErrEnum err;

    public SecurityEventTokenError() {
    }

    public SecurityEventTokenError description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Describes the error &gt; **Note:** SET claim fields with underscores (snake case) are presented in camelcase. For
     * example, &#x60;previous_status&#x60; appears as &#x60;previousStatus&#x60;.
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Failed claim validation in security event token. 'events.mediationDeviceComplianceChangeEvent.previousStatus': The field cannot be left blank", value = "Describes the error > **Note:** SET claim fields with underscores (snake case) are presented in camelcase. For example, `previous_status` appears as `previousStatus`. ")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public SecurityEventTokenError err(ErrEnum err) {

        this.err = err;
        return this;
    }

    /**
     * A code that describes the category of the error
     *
     * @return err
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "invalid_request", value = "A code that describes the category of the error")
    @JsonProperty(JSON_PROPERTY_ERR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ErrEnum getErr() {
        return err;
    }

    @JsonProperty(JSON_PROPERTY_ERR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setErr(ErrEnum err) {
        this.err = err;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurityEventTokenError securityEventTokenError = (SecurityEventTokenError) o;
        return Objects.equals(this.description, securityEventTokenError.description)
                && Objects.equals(this.err, securityEventTokenError.err);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, err);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventTokenError {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    err: ").append(toIndentedString(err)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
