package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SimulateResultConditions;
import com.okta.sdk.resource.model.SimulateResultStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SimulateResultRules
 */
@JsonPropertyOrder({ SimulateResultRules.JSON_PROPERTY_CONDITIONS, SimulateResultRules.JSON_PROPERTY_ID,
        SimulateResultRules.JSON_PROPERTY_NAME, SimulateResultRules.JSON_PROPERTY_STATUS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SimulateResultRules implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private List<SimulateResultConditions> conditions = null;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_STATUS = "status";
    private SimulateResultStatus status;

    public SimulateResultRules() {
    }

    public SimulateResultRules conditions(List<SimulateResultConditions> conditions) {

        this.conditions = conditions;
        return this;
    }

    public SimulateResultRules addconditionsItem(SimulateResultConditions conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    /**
     * List of all conditions involved for this rule evaluation
     *
     * @return conditions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of all conditions involved for this rule evaluation")
    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<SimulateResultConditions> getConditions() {
        return conditions;
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(List<SimulateResultConditions> conditions) {
        this.conditions = conditions;
    }

    public SimulateResultRules id(String id) {

        this.id = id;
        return this;
    }

    /**
     * The unique ID number of the policy rule
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique ID number of the policy rule")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public SimulateResultRules name(String name) {

        this.name = name;
        return this;
    }

    /**
     * The name of the policy rule
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The name of the policy rule")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public SimulateResultRules status(SimulateResultStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SimulateResultStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(SimulateResultStatus status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SimulateResultRules simulateResultRules = (SimulateResultRules) o;
        return Objects.equals(this.conditions, simulateResultRules.conditions)
                && Objects.equals(this.id, simulateResultRules.id)
                && Objects.equals(this.name, simulateResultRules.name)
                && Objects.equals(this.status, simulateResultRules.status);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(conditions, id, name, status);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimulateResultRules {\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
