package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Defines the secondary authenticators needed for password reset if &#x60;required&#x60; is true. The following are
 * three valid configurations: * &#x60;required&#x60;&#x3D;false * &#x60;required&#x60;&#x3D;true with no methods to use
 * any SSO authenticator * &#x60;required&#x60;&#x3D;true with &#x60;security_question&#x60; as the method
 */
@ApiModel(description = "Defines the secondary authenticators needed for password reset if `required` is true. The following are three valid configurations: * `required`=false * `required`=true with no methods to use any SSO authenticator * `required`=true with `security_question` as the method")
@JsonPropertyOrder({ SsprStepUpRequirement.JSON_PROPERTY_METHODS, SsprStepUpRequirement.JSON_PROPERTY_REQUIRED })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SsprStepUpRequirement implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Gets or Sets methods
     */
    public enum MethodsEnum {
        SECURITY_QUESTION("security_question"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        MethodsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static MethodsEnum fromValue(String value) {
            for (MethodsEnum b : MethodsEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_METHODS = "methods";
    private List<MethodsEnum> methods = null;

    public static final String JSON_PROPERTY_REQUIRED = "required";
    private Boolean required;

    public SsprStepUpRequirement() {
    }

    public SsprStepUpRequirement methods(List<MethodsEnum> methods) {

        this.methods = methods;
        return this;
    }

    public SsprStepUpRequirement addmethodsItem(MethodsEnum methodsItem) {
        if (this.methods == null) {
            this.methods = new ArrayList<>();
        }
        this.methods.add(methodsItem);
        return this;
    }

    /**
     * Authenticator methods required for secondary authentication step of password recovery. Specify this value only
     * when &#x60;required&#x60; is true and &#x60;security_question&#x60; is permitted for the secondary
     * authentication.
     *
     * @return methods
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Authenticator methods required for secondary authentication step of password recovery. Specify this value only when `required` is true and `security_question` is permitted for the secondary authentication.")
    @JsonProperty(JSON_PROPERTY_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<MethodsEnum> getMethods() {
        return methods;
    }

    @JsonProperty(JSON_PROPERTY_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMethods(List<MethodsEnum> methods) {
        this.methods = methods;
    }

    public SsprStepUpRequirement required(Boolean required) {

        this.required = required;
        return this;
    }

    /**
     * Get required
     *
     * @return required
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getRequired() {
        return required;
    }

    @JsonProperty(JSON_PROPERTY_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SsprStepUpRequirement ssprStepUpRequirement = (SsprStepUpRequirement) o;
        return Objects.equals(this.methods, ssprStepUpRequirement.methods)
                && Objects.equals(this.required, ssprStepUpRequirement.required);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(methods, required);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SsprStepUpRequirement {\n");
        sb.append("    methods: ").append(toIndentedString(methods)).append("\n");
        sb.append("    required: ").append(toIndentedString(required)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
