package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Message profile specifies information about the telephony (sms/voice) message to be sent to the Okta user
 */
@ApiModel(description = "Message profile specifies information about the telephony (sms/voice) message to be sent to the Okta user")
@JsonPropertyOrder({ TelephonyRequestDataMessageProfile.JSON_PROPERTY_MSG_TEMPLATE,
        TelephonyRequestDataMessageProfile.JSON_PROPERTY_PHONE_NUMBER,
        TelephonyRequestDataMessageProfile.JSON_PROPERTY_OTP_EXPIRES,
        TelephonyRequestDataMessageProfile.JSON_PROPERTY_DELIVERY_CHANNEL,
        TelephonyRequestDataMessageProfile.JSON_PROPERTY_OTP_CODE,
        TelephonyRequestDataMessageProfile.JSON_PROPERTY_LOCALE })
@JsonTypeName("TelephonyRequestData_messageProfile")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TelephonyRequestDataMessageProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_MSG_TEMPLATE = "msgTemplate";
    private String msgTemplate;

    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private String phoneNumber;

    public static final String JSON_PROPERTY_OTP_EXPIRES = "otpExpires";
    private String otpExpires;

    public static final String JSON_PROPERTY_DELIVERY_CHANNEL = "deliveryChannel";
    private String deliveryChannel;

    public static final String JSON_PROPERTY_OTP_CODE = "otpCode";
    private String otpCode;

    public static final String JSON_PROPERTY_LOCALE = "locale";
    private String locale;

    public TelephonyRequestDataMessageProfile() {
    }

    public TelephonyRequestDataMessageProfile msgTemplate(String msgTemplate) {

        this.msgTemplate = msgTemplate;
        return this;
    }

    /**
     * Default or Okta org configured sms or voice message template
     *
     * @return msgTemplate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Default or Okta org configured sms or voice message template")
    @JsonProperty(JSON_PROPERTY_MSG_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getMsgTemplate() {
        return msgTemplate;
    }

    @JsonProperty(JSON_PROPERTY_MSG_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMsgTemplate(String msgTemplate) {
        this.msgTemplate = msgTemplate;
    }

    public TelephonyRequestDataMessageProfile phoneNumber(String phoneNumber) {

        this.phoneNumber = phoneNumber;
        return this;
    }

    /**
     * The Okta&#39;s user&#39;s phone number
     *
     * @return phoneNumber
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Okta's user's phone number")
    @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPhoneNumber() {
        return phoneNumber;
    }

    @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public TelephonyRequestDataMessageProfile otpExpires(String otpExpires) {

        this.otpExpires = otpExpires;
        return this;
    }

    /**
     * The time when OTP expires
     *
     * @return otpExpires
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The time when OTP expires")
    @JsonProperty(JSON_PROPERTY_OTP_EXPIRES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOtpExpires() {
        return otpExpires;
    }

    @JsonProperty(JSON_PROPERTY_OTP_EXPIRES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOtpExpires(String otpExpires) {
        this.otpExpires = otpExpires;
    }

    public TelephonyRequestDataMessageProfile deliveryChannel(String deliveryChannel) {

        this.deliveryChannel = deliveryChannel;
        return this;
    }

    /**
     * The channel for OTP delivery - SMS or voice
     *
     * @return deliveryChannel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The channel for OTP delivery - SMS or voice")
    @JsonProperty(JSON_PROPERTY_DELIVERY_CHANNEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDeliveryChannel() {
        return deliveryChannel;
    }

    @JsonProperty(JSON_PROPERTY_DELIVERY_CHANNEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryChannel(String deliveryChannel) {
        this.deliveryChannel = deliveryChannel;
    }

    public TelephonyRequestDataMessageProfile otpCode(String otpCode) {

        this.otpCode = otpCode;
        return this;
    }

    /**
     * The OTP code requested by the Okta user
     *
     * @return otpCode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The OTP code requested by the Okta user")
    @JsonProperty(JSON_PROPERTY_OTP_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOtpCode() {
        return otpCode;
    }

    @JsonProperty(JSON_PROPERTY_OTP_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOtpCode(String otpCode) {
        this.otpCode = otpCode;
    }

    public TelephonyRequestDataMessageProfile locale(String locale) {

        this.locale = locale;
        return this;
    }

    /**
     * The locale associated with the Okta user
     *
     * @return locale
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The locale associated with the Okta user")
    @JsonProperty(JSON_PROPERTY_LOCALE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLocale() {
        return locale;
    }

    @JsonProperty(JSON_PROPERTY_LOCALE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TelephonyRequestDataMessageProfile telephonyRequestDataMessageProfile = (TelephonyRequestDataMessageProfile) o;
        return Objects.equals(this.msgTemplate, telephonyRequestDataMessageProfile.msgTemplate)
                && Objects.equals(this.phoneNumber, telephonyRequestDataMessageProfile.phoneNumber)
                && Objects.equals(this.otpExpires, telephonyRequestDataMessageProfile.otpExpires)
                && Objects.equals(this.deliveryChannel, telephonyRequestDataMessageProfile.deliveryChannel)
                && Objects.equals(this.otpCode, telephonyRequestDataMessageProfile.otpCode)
                && Objects.equals(this.locale, telephonyRequestDataMessageProfile.locale);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(msgTemplate, phoneNumber, otpExpires, deliveryChannel, otpCode, locale);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelephonyRequestDataMessageProfile {\n");
        sb.append("    msgTemplate: ").append(toIndentedString(msgTemplate)).append("\n");
        sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
        sb.append("    otpExpires: ").append(toIndentedString(otpExpires)).append("\n");
        sb.append("    deliveryChannel: ").append(toIndentedString(deliveryChannel)).append("\n");
        sb.append("    otpCode: ").append(toIndentedString(otpCode)).append("\n");
        sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
